/* Disassemble 68hc05 instructions.
   Copyright (C) 1999 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include "dis-asm.h"

enum t_mode {
  t_dirrel,
  t_dir,
  t_rel,
  t_inh,
  t_imm,
  t_ext,
  t_ix2,
  t_ix1,
  t_ix,
  t_inv,
  num_modes
};
static const int mode_size[num_modes] = { 2, 1, 1, 0, 1, 2, 2, 1, 0, 0 };
static const struct
{
  char name[7];
  char mode;
} opcodes[256] = 
{ { "brset0", t_dirrel }, { "brclr0", t_dirrel }, 
  { "brset1", t_dirrel }, { "brclr1", t_dirrel }, 
  { "brset2", t_dirrel }, { "brclr2", t_dirrel }, 
  { "brset3", t_dirrel }, { "brclr3", t_dirrel }, 
  { "brset4", t_dirrel }, { "brclr4", t_dirrel }, 
  { "brset5", t_dirrel }, { "brclr5", t_dirrel }, 
  { "brset6", t_dirrel }, { "brclr6", t_dirrel }, 
  { "brset7", t_dirrel }, { "brclr7", t_dirrel }, 
  { "bset0", t_dir }, { "bclr0", t_dir }, 
  { "bset1", t_dir }, { "bclr1", t_dir }, 
  { "bset2", t_dir }, { "bclr2", t_dir }, 
  { "bset3", t_dir }, { "bclr3", t_dir }, 
  { "bset4", t_dir }, { "bclr4", t_dir }, 
  { "bset5", t_dir }, { "bclr5", t_dir }, 
  { "bset6", t_dir }, { "bclr6", t_dir }, 
  { "bset7", t_dir }, { "bclr7", t_dir }, 
  {"bra", t_rel }, {"brn", t_rel }, {"bhi", t_rel }, {"bls", t_rel },
  {"bcc", t_rel }, {"bcs", t_rel }, {"bne", t_rel }, {"beq", t_rel },
  {"bhcc", t_rel }, {"bhcs", t_rel }, {"bpl", t_rel }, {"bmi", t_rel },
  {"bmc", t_rel }, {"bms", t_rel }, {"bil", t_rel }, {"bih", t_rel },
  {"neg", t_dir }, {"", t_inv }, {"", t_inv }, {"com", t_dir },
  {"lsr", t_dir }, {"", t_inv }, {"ror", t_dir }, {"asr", t_dir },
  {"lsl", t_dir }, {"rol", t_dir }, {"dec", t_dir }, {"dbg", t_dir }, 
  {"inc", t_dir }, {"tst", t_dir }, {"", t_inv }, {"clr", t_dir },
  {"nega", t_inh }, {"", t_inv }, {"mul", t_inh }, {"coma", t_inh },
  {"lsra", t_inh }, {"", t_inv }, {"rora", t_inh }, {"asra", t_inh },
  {"lsla", t_inh }, {"rola", t_inh }, {"deca", t_inh }, {"dbga", t_inh }, 
  {"inca", t_inh }, {"tsta", t_inh }, {"", t_inv }, {"clra", t_inh },
  {"negx", t_inh }, {"", t_inv }, {"", t_inv }, {"comx", t_inh },
  {"lsrx", t_inh }, {"", t_inv }, {"rorx", t_inh }, {"asrx", t_inh },
  {"lslx", t_inh }, {"rolx", t_inh }, {"decx", t_inh }, {"dbgx", t_inh }, 
  {"incx", t_inh }, {"tstx", t_inh }, {"", t_inv }, {"clrx", t_inh },
  {"neg", t_ix1 }, {"", t_inv }, {"", t_inv }, {"com", t_ix1 },
  {"lsr", t_ix1 }, {"", t_inv }, {"ror", t_ix1 }, {"asr", t_ix1 },
  {"lsl", t_ix1 }, {"rol", t_ix1 }, {"dec", t_ix1 }, {"dbg", t_ix1 }, 
  {"inc", t_ix1 }, {"tst", t_ix1 }, {"", t_inv }, {"clr", t_ix1 },
  {"neg", t_ix }, {"", t_inv }, {"", t_inv }, {"com", t_ix },
  {"lsr", t_ix }, {"", t_inv }, {"ror", t_ix }, {"asr", t_ix },
  {"lsl", t_ix }, {"rol", t_ix }, {"dec", t_ix }, {"dbg", t_ix }, 
  {"inc", t_ix }, {"tst", t_ix }, {"", t_inv }, {"clr", t_ix },
  {"rti", t_inh }, {"rts", t_inh }, {"", t_inv }, {"swi", t_inh },
  {"", t_inv }, {"", t_inv }, {"", t_inv }, {"", t_inv },
  {"", t_inv }, {"", t_inv }, {"", t_inv }, {"", t_inv },
  {"", t_inv }, {"", t_inv }, {"stop", t_inh }, {"wait", t_inh },
  {"", t_inv }, {"", t_inv }, {"", t_inv }, {"", t_inv },
  {"", t_inv }, {"", t_inv }, {"", t_inv }, {"tax", t_inh },
  {"clc", t_inh }, {"sec", t_inh }, {"cli", t_inh }, {"sei", t_inh },
  {"rsp", t_inh }, {"nop", t_inh }, {"", t_inv }, {"txa", t_inh },
  {"sub", t_imm }, {"cmp", t_imm }, {"sbc", t_imm }, {"cpx", t_imm },
  {"and", t_imm }, {"bit", t_imm }, {"lda", t_imm }, {"", t_inv },
  {"eor", t_imm }, {"adc", t_imm }, {"ora", t_imm }, {"add", t_imm },
  {"", t_inv }, {"bsr", t_rel }, {"ldx", t_imm }, {"", t_inv },
  {"sub", t_dir }, {"cmp", t_dir }, {"sbc", t_dir }, {"cpx", t_dir },
  {"and", t_dir }, {"bit", t_dir }, {"lda", t_dir }, {"sta", t_dir },
  {"eor", t_dir }, {"adc", t_dir }, {"ora", t_dir }, {"add", t_dir },
  {"jmp", t_dir }, {"jsr", t_dir }, {"ldx", t_dir }, {"stx", t_dir },
  {"sub", t_ext }, {"cmp", t_ext }, {"sbc", t_ext }, {"cpx", t_ext },
  {"and", t_ext }, {"bit", t_ext }, {"lda", t_ext }, {"sta", t_ext },
  {"eor", t_ext }, {"adc", t_ext }, {"ora", t_ext }, {"add", t_ext },
  {"jmp", t_ext }, {"jsr", t_ext }, {"ldx", t_ext }, {"stx", t_ext },
  {"sub", t_ix2 }, {"cmp", t_ix2 }, {"sbc", t_ix2 }, {"cpx", t_ix2 },
  {"and", t_ix2 }, {"bit", t_ix2 }, {"lda", t_ix2 }, {"sta", t_ix2 },
  {"eor", t_ix2 }, {"adc", t_ix2 }, {"ora", t_ix2 }, {"add", t_ix2 },
  {"jmp", t_ix2 }, {"jsr", t_ix2 }, {"ldx", t_ix2 }, {"stx", t_ix2 },
  {"sub", t_ix1 }, {"cmp", t_ix1 }, {"sbc", t_ix1 }, {"cpx", t_ix1 },
  {"and", t_ix1 }, {"bit", t_ix1 }, {"lda", t_ix1 }, {"sta", t_ix1 },
  {"eor", t_ix1 }, {"adc", t_ix1 }, {"ora", t_ix1 }, {"add", t_ix1 },
  {"jmp", t_ix1 }, {"jsr", t_ix1 }, {"ldx", t_ix1 }, {"stx", t_ix1 },
  {"sub", t_ix }, {"cmp", t_ix }, {"sbc", t_ix }, {"cpx", t_ix },
  {"and", t_ix }, {"bit", t_ix }, {"lda", t_ix }, {"sta", t_ix },
  {"eor", t_ix }, {"adc", t_ix }, {"ora", t_ix }, {"add", t_ix },
  {"jmp", t_ix }, {"jsr", t_ix }, {"ldx", t_ix }, {"stx", t_ix }
};
  
int 
print_insn_m6805(memaddr, info)
     bfd_vma memaddr;
     struct disassemble_info *info;
{
  bfd_byte buffer[3];
  int status;
  
  info->bytes_per_chunk = 1;
  /* info->bytes_per_line = 4; */
  info->display_endian = BFD_ENDIAN_BIG;
  info->branch_delay_insns = 0;
  info->insn_info_valid = 1;
  info->insn_type = dis_nonbranch;
  info->target = 0;

  status = (*info->read_memory_func) (memaddr, buffer, 1, info);
  if (status == 0 && mode_size[opcodes[buffer[0]].mode] > 0)
    status = (*info->read_memory_func) (memaddr+1, buffer+1, 
					mode_size[opcodes[buffer[0]].mode],
					info);
  if (status != 0)
    {
      (*info->memory_error_func) (status, memaddr, info);
      return -1;
    }
  if (opcodes[buffer[0]].mode == t_inv)
    (*info->fprintf_func) (info->stream, "byte", opcodes[buffer[0]].name);
  else
    (*info->fprintf_func) (info->stream, "%s", opcodes[buffer[0]].name);
  switch (opcodes[buffer[0]].mode)
    {
    case t_inv:
      (*info->fprintf_func) (info->stream, "\t0x%02x", buffer[0]);
      info->insn_type = dis_noninsn;
      break;
    case t_inh:
      break;
    case t_imm:
      (*info->fprintf_func) (info->stream, "\t#0x%02x", buffer[1]);
      break;
    case t_dir:
      (*info->fprintf_func) (info->stream, "\t0x%02x", buffer[1]);
      info->insn_type = dis_dref;
      info->target = buffer[1];
      break;
    case t_ext:
      (*info->fprintf_func) (info->stream, "\t0x%02x%02x", 
			     buffer[1], buffer[2]);
      info->insn_type = dis_dref;
      info->target = buffer[1] << 8 | buffer[2];
      break;
    case t_ix:
      (*info->fprintf_func) (info->stream, ",X");
      info->insn_type = dis_dref;
      break;
    case t_ix1:
      (*info->fprintf_func) (info->stream, "\t0x%02x,X", buffer[1]);
      info->insn_type = dis_dref;
      break;
    case t_ix2:
      (*info->fprintf_func) (info->stream, "\t0x%02x%02x,X", 
			     buffer[1], buffer[2]);
      info->insn_type = dis_dref;
      break;
    case t_rel:
      (*info->fprintf_func) (info->stream, "\t0x%04x", 
			     ((buffer[1] ^ 128) - 128) + memaddr + 2);
      info->insn_type = dis_condbranch;
      info->target = buffer[1] + memaddr + 2;
      break;
    case t_dirrel:
      (*info->fprintf_func) (info->stream, "\t0x%02x,0x%04x", 
			     buffer[1], buffer[2] + memaddr + 2);
      info->insn_type = dis_condbranch;
      info->target = buffer[2] + memaddr + 2;
      break;
    }
  return 1+mode_size[opcodes[buffer[0]].mode];
}
