dnl -*- mode: m4; comment-start: "%" -*-
include(`macros.m4')divert(-1)
% $Id: rijndael.m4,v 1.13 1999/04/15 03:01:07 geoffk Exp $

define(v_K, 0xC0)	The key, stored big-endian.
define(v_state, 0xD0)	The block to encrypt
define(v_W, 0xE0)	The current round keys.
define(v_round, 0xF0)	The round number.
define(v_mixc_tmp, 0xF1)Temporary for MixColumn
define(test_ram, 0xF2)	Memory for the test program.

define(NUMROUNDS,10)

divert`'dnl

const_RC:
	bytes(0x36,0x1B,0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01)

% The main Rijndael routine.
% Inputs:  plaintext in v_state, key in v_K
% Outputs: ciphertext in v_state.
rijndael_e:
% Perform the initial key XOR, copy the key into v_W.
	ldx	#0x10-1
e_key_copy_loop:
	lda	v_K,X
	sta	v_W,X
	eor	v_state,X
	sta	v_state,X
	decx
	bpl	e_key_copy_loop
	
	lda	#NUMROUNDS-1
	sta	v_round
e_round_loop:
% Do the ByteSub and ShiftRow transformations
% First row:
forloop(`i',0,3,`dnl
	ldx	v_state+eval(i*4)
	ldx	rijndael_sbox_e,X
	stx	v_state+eval(i*4)
')dnl
% Second row:
	ldx	v_state+1+0
	lda	rijndael_sbox_e,X
forloop(`i',1,3,`dnl
	ldx	v_state+1+eval(i*4)
	ldx	rijndael_sbox_e,X
	stx	v_state+1+eval((i-1)*4)
')dnl
	sta	v_state+1+eval(3*4)
% Third row:
forloop(`i',0,1,`dnl
	ldx	v_state+2+eval(i*4)
	lda	rijndael_sbox_e,X
	ldx	v_state+2+eval((i+2)*4)
	ldx	rijndael_sbox_e,X
	stx	v_state+2+eval(i*4)
	sta	v_state+2+eval((i+2)*4)
')dnl
% Fourth row:
	ldx	v_state+3+eval(3*4)
	lda	rijndael_sbox_e,X
foreach(`i',`2,1,0',`dnl
	ldx	v_state+3+eval(i*4)
	ldx	rijndael_sbox_e,X
	stx	v_state+3+eval((i+1)*4)
')dnl
	sta	v_state+3+eval(0*4)

% Do the MixColumn transformation, except during the final round
	tst	v_round
	bne	e_do_mixcolumn
	jmp	e_no_mixcolumn

e_do_mixcolumn:	
foreach(`j',`0,4,8,12',`dnl
	lda	0+j+v_state
	eor	1+j+v_state
	eor	2+j+v_state
	eor	3+j+v_state
	sta	v_mixc_tmp

define(`xtime',`lsla
newlabel`'dnl
	bcs	Tlbl`'_0
	nop
Tlbl`'_0:
	bcc	Tlbl`'_1
	eor	#0x1B
Tlbl`'_1:')dnl
forloop(`i',0,2,`dnl
	lda	i+j+v_state
	eor	i+1+j+v_state
	xtime
	eor	v_mixc_tmp
	eor	i+j+v_state
	sta	i+j+v_state
')dnl

% Do the last word specially
% Here, the accumulator contains the appropriate byte of the previous word.
	eor	0+j+v_state
	eor	1+j+v_state
	eor	v_mixc_tmp
	sta	3+j+v_state
')
	
e_no_mixcolumn:
% Update the key schedule and perform the key XOR
forloop(`i',0,3,`dnl
	ldx	v_W+eval(3*4)+eval((i+1)&3)
	lda	rijndael_sbox_e,X
ifelse(i,0,`dnl
	ldx	v_round
	eor	const_RC,X
')dnl
	eor	v_W+i
	sta	v_W+i
	eor	v_state+i
	sta	v_state+i
')dnl
	
forloop(`i',0,3,`dnl
	lda	v_W+i
	eor	v_W+4+i
	sta	v_W+4+i
	eor	v_W+8+i
	sta	v_W+8+i
	eor	v_W+12+i
	sta	v_W+12+i
	eor	v_state+12+i
	sta	v_state+12+i
	lda	v_W+4+i
	eor	v_state+4+i
	sta	v_state+4+i
	lda	v_W+8+i
	eor	v_state+8+i
	sta	v_state+8+i
')dnl

% Perhaps that was the last round.
	dec	v_round
	bpl	e_more_round_loop
	
% We're done!
	rts

e_more_round_loop:
	jmp	e_round_loop

% These are the rijndael S-boxes.
rijndael_sbox_e:
define(`pow_tab',quote(define(`p',1)`'dnl
forloop(`i',0,254,`p, dnl
define(`log_tab_'p,i)dnl
define(`p',eval(p ^ ((p << 1) & 0xFF) ifelse(eval(p&0x80),0,`',^ 0x1b)))dnl
')p))dnl
	byte 0x63
forloop(`i',1,255,`dnl
define(`p',choosei(eval(255-first(`log_tab_'i)), `pow_tab'))dnl
	byte 0x63^p`'dnl
forloop(`j',1,4,`^eval(((p >> (8-j)) | (p << j)) & 0xFF)')
')dnl

test_program(test_ram,v_K,16,v_state,v_state,16,`',jsr rijndael_e)

test_data:
xbytes(00000000000000000000000000000000
	00000000000000000000000000000000 66e94bd4ef8a2c3b884cfa59ca342b2e)
xbytes(00000000000000000000000000000000
	66e94bd4ef8a2c3b884cfa59ca342b2e f795bd4a52e29ed713d313fa20e98dbc)
xbytes(00000000000000000000000000000000
	f795bd4a52e29ed713d313fa20e98dbc a10cf66d0fddf3405370b4bf8df5bfb3)
xbytes(a10cf66d0fddf3405370b4bf8df5bfb3
	00000000000000000000000000000000 d6f6a9c7e08242fc7e0c6eacd7257837)
xbytes(a10cf66d0fddf3405370b4bf8df5bfb3
	d6f6a9c7e08242fc7e0c6eacd7257837 6e3187c0e66f5bf72554093c6f4a03f4)
test_data_end:
