dnl -*- mode: m4; comment-start: "%" -*-
ifdef(`m_RESETv',`',`include(`macros.m4')')
% $Id: serpent-sboxes.m4,v 1.1 1999/02/18 05:49:35 geoffk Exp $

% All these macros take the same three parameters:
% destination, source, workspace
% each of size 4 bytes (and, except for the first entries,
% always accessed by writing x+$y where x is 0..3, y is 0, 1, or 2.

% t0 = a ^ b ^ c ^ d  [t4]
% t1 = ((a ^ d) & b) ^ a  [t7]
% g = (t1 | c) ^ t0
% h = (a & d) ^ t0
% e = ~((t0 ^ b ^ t1) & h) ^ t1
% f = e ^ t1 ^ t0 ^ b
define(`sbox_0',`dnl
	lda	$2
	eor	1+$2
	eor	2+$2
	eor	3+$2
	sta	0+$3
	lda	$2
	eor	3+$2
	and	1+$2
	eor	$2
	sta	1+$3
	ora	2+$2
	eor	0+$3
	sta	2+$1
	lda	$2
	and	3+$2
	eor	0+$3
	sta	3+$1
	lda	0+$3
	eor	1+$2
	eor	1+$3
	and	3+$1
	eor	#0xFF
	eor	1+$3
	sta	$1
	eor	0+$3
	eor	1+$3
	eor	1+$2
	sta	1+$1
')dnl
% t0 = ~a ^ b   [t2]
% t1 = (t0 | a) ^ c  [t5]
% t2 = (t0 | d) ^ b  [t7]
% t3 = t2 ^ t1  [t11]
% g = t1 ^ d
% e = ((g ^ t0) & t3) ^ t1
% h = (t1 & t2) ^ g ^ t0
% f = h ^ t3
define(`sbox_1',`dnl
	lda	$2
	eor	1+$2
	eor	#0xFF
	sta	0+$3
	ora	$2
	eor	2+$2
	sta	1+$3
	lda	0+$3
	ora	3+$2
	eor	1+$2
	sta	2+$3
	eor	1+$3
	sta	3+$3
	lda	1+$3
	eor	3+$2
	sta	2+$1
	eor	0+$3
	and	3+$3
	eor	1+$3
	sta	$1
	lda	1+$3
	and	2+$3
	eor	2+$1
	eor	0+$3
	sta	3+$1
	eor	3+$3
	sta	1+$1
')
% t0 = ~a ^ c  [t5]
% e = (~t0 & c) ^ b ^ d
% t1 = e | t0  [t10]
% h = ((c ^ e) & b) ^ t0
% g = (((h ^ t0) | d) & t1) ^ a
% f = (~a | d) ^ g ^ b ^ d ^ h
define(`sbox_2',`dnl
	lda	$2
	eor	2+$2
	eor	#0xFF
	sta	0+$3
	eor	#0xFF
	and	2+$2
	eor	1+$2
	eor	3+$2
	sta	$1
	ora	0+$3
	sta	1+$3
	lda	2+$2
	eor	$1
	and	1+$2
	eor	0+$3
	sta	3+$1
	eor	0+$3
	ora	3+$2
	and	1+$3
	eor	$2
	sta	2+$1
	lda	$2
	eor	#0xFF
	ora	3+$2
	eor	2+$1
	eor	1+$2
	eor	3+$2
	eor	3+$1
	sta	1+$1
')
% t0 = (a | d) ^ b  [t12]
% t1 = a ^ c ^ d  [t2]
% t2 = (t1 & a) ^ d  [t4]
% g = (t2 & b) ^ t1
% t3 = (g | a) & t2  [t9]
% h = t3 ^ t0 ^ g
% f = (b | d) ^ t3
% e = (((a & t1) ^ f ^ t3) & c) ^ t0
define(`sbox_3',`dnl
	lda	$2
	ora	3+$2
	eor	1+$2
	sta	0+$3
	lda	$2
	eor	2+$2
	eor	3+$2
	sta	1+$3
	and	$2
	eor	3+$2
	sta	2+$3
	and	1+$2
	eor	1+$3
	sta	2+$1
	ora	$2
	and	2+$3
	sta	3+$3
	eor	0+$3
	eor	2+$1
	sta	3+$1
	lda	1+$2
	ora	3+$2
	eor	3+$3
	sta	1+$1
	lda	$2
	and	1+$3
	eor	1+$1
	eor	3+$3
	and	2+$2
	eor	0+$3
	sta	$1
')dnl
% t0 = a ^ d  [t1]
% t1 = (t0 & d) ^ c  [t3]
% h = (t1 | b) ^ t0
% e = (~b | t0) ^ t1
% t2 = e & a  [t9]
% t3 = ~(t0 ^ b)  [t10]
% g = ((t1 | b) & t3) ^ t2
% f = (g & t3) ^ a ^ t1
define(`sbox_4',`dnl
	lda	$2
	eor	3+$2
	sta	0+$3
	and	3+$2
	eor	2+$2
	sta	1+$3
	ora	1+$2
	eor	0+$3
	sta	3+$1
	lda	1+$2
	eor	#0xFF
	ora	0+$3
	eor	1+$3
	sta	$1
	and	$2
	sta	2+$3
	lda	0+$3
	eor	1+$2
	eor	#0xFF
	sta	3+$3
	lda	1+$3
	ora	1+$2
	and	3+$3
	eor	2+$3
	sta	2+$1
	and	3+$3
	eor	$2
	eor	1+$3
	sta	1+$1
')
% t0 = a ^ b  [t2]
% e = ~(((a ^ d) | t0) ^ a ^ c)
% t1 = e & d  [t7]
% f = t1 ^ t0 ^ e
% t2 = (~a | e) ^ a ^ d  [t12]
% h = (t2 & f) ^ b ^ t1
% g = (t0 | t1) ^ t2
define(`sbox_5',`dnl
	lda	$2
	eor	1+$2
	sta	0+$3
	lda	$2
	eor	3+$2
	ora	0+$3
	eor	$2
	eor	2+$2
	eor	#0xFF
	sta	$1
	and	3+$2
	sta	1+$3
	eor	0+$3
	eor	$1
	sta	1+$1
	lda	$2
	eor	#0xFF
	ora	$1
	eor	$2
	eor	3+$2
	sta	2+$3
	and	1+$1
	eor	1+$2
	eor	1+$3
	sta	3+$1
	lda	0+$3
	ora	1+$3
	eor	2+$3
	sta	2+$1
')
% t0 = a ^ d  [t2]
% t1 = ~(~t0 & a) ^ c  [t5]
% f = t1 ^ b
% t2 = (f | t0) ^ d  [t8]
% g = (t2 & t1) ^ b ^ t0
% e = g ^ t1 ^ t2
% t3 = e ^ g  [t11]
% h = ~((b ^ t0) & t3) ^ t1
define(`sbox_6',`dnl
	lda	$2
	eor	3+$2
	sta	0+$3
	eor	#0xFF
	and	$2
	eor	#0xFF
	eor	2+$2
	sta	1+$3
	eor	1+$2
	sta	1+$1
	ora	0+$3
	eor	3+$2
	sta	2+$3
	and	1+$3
	eor	1+$2
	eor	0+$3
	sta	2+$1
	eor	1+$3
	eor	2+$3
	sta	$1
	eor	2+$1
	sta	3+$3
	lda	1+$2
	eor	0+$3
	and	3+$3
	eor	#0xFF
	eor	1+$3
	sta	3+$1
')
% t1 = (~c | b) ^ d  [t4]
% t2 = t1 & a  [t5]
% t3 = t2 ^ b  [t8]
% h = t3 ^ c
% t0 = ~t1 & d  [t11]
% f = ((b ^ c) | t3) ^ a ^ d
% g = ((f ^ t2) & h) ^ t0
% e = (~c | t1) ^ g ^ t2 ^ f
define(`sbox_7',`dnl
	lda	2+$2
	eor	#0xFF
	ora	1+$2
	eor	3+$2
	sta	1+$3
	and	$2
	sta	2+$3
	eor	1+$2
	sta	3+$3
	eor	2+$2
	sta	3+$1
	lda	1+$3
	eor	#0xFF
	and	3+$2
	sta	0+$3
	lda	1+$2
	eor	2+$2
	ora	3+$3
	eor	$2
	eor	3+$2
	sta	1+$1
	eor	2+$3
	and	3+$1
	eor	0+$3
	sta	2+$1
	lda	2+$2
	eor	#0xFF
	ora	1+$3
	eor	2+$1
	eor	2+$3
	eor	1+$1
	sta	$1
')

testinputs:
	word	0xAAAA
	word	0xCCCC
	word	0xF0F0
	word	0xFF00

testvalues: xbytes(
52cd 19b5 9764 c396
6359 568d b44b 2e93
639c a4d6 4da6 25e9
63a6 b4c6 e952 913e
d24b 69ca e692 b856
d24b 662d 7493 1ce9
3e89 69c3 196d 5b94
7187 a9d4 c716 1cb6
)

define(`sbox_test',`dnl
	ldx	#7
copy_loop_`'$1:
	lda	testinputs,X
	sta	0xC0,X
	decx
	bpl	copy_loop_`'$1

	dbg	0x80+$1

	ldx	#0xC0
doit_loop_`'$1:
	sbox_$1(`0*2+8,X',`0*2,X',0xD0)
	incx
	cpx	#0xC2
	bne	doit_loop_`'$1

	dbg	0x80+$1

	ldx	#7
check_loop_`'$1:
	lda	testvalues+eval($1*8),X
	cmp	0xC8,X
	bne	check_failed_`'$1
	decx
	bpl	check_loop_`'$1
	bra	check_ok_`'$1
check_failed_`'$1:
	dbgx
	dbga
	dbg	0xC8,X
check_ok_`'$1:
')

testprogram:
forloop(`i',0,7,`sbox_test(i)')
	stop

	org	m_RESETv
	word	testprogram
