$Id: sha-m4.m4,v 1.2 1999/02/14 02:19:16 geoffk Exp $

This is the SHA-1 algorithm implemented in M4.

Call it with parameters 1 being a list containing H_0 through H_4,
and parameter 2 containing the words to process (16 of them).
Returns a list H_0 through H_4.

ifdef(`forloop',,`
define(`forloop',`pushdef(`$1',`$2')_forloop(`$1',`$2',`$3',`$4')popdef(`$1')')
define(`_forloop',dnl
`$4`'ifelse($1, `$3', ,dnl
`define(`$1', incr($1))_forloop(`$1', `$2', `$3', `$4')')')
define(first,`$1')
define(choosei,`pushdef(`x',$eval($1+1))x($2)`'popdef(`x')')
define(quote,``$@'')
')

These are the f functions.
define(`sha_f_0',`eval((tmp_sha_A1 & tmp_sha_A2) | 
		       (~tmp_sha_A1 & tmp_sha_A3))')
define(`sha_f_1',`eval(tmp_sha_A1 ^ tmp_sha_A2 ^ tmp_sha_A3)')
define(`sha_f_2',`eval((tmp_sha_A1 & tmp_sha_A2) | 
		       (tmp_sha_A1 & tmp_sha_A3) | 
		       (tmp_sha_A2 & tmp_sha_A3))')
define(`sha_f_3',defn(`sha_f_1'))
The K constants.
define(`sha_K',`0x5a827999,0x6ed9eba1,0x8f1bbcdc,0xca62c1d6')

define(`sha_1',`dnl
pushdef(`tmp_sha_tmp')dnl
forloop(`i',0,15,`pushdef(`tmp_sha_W_'i,choosei(i,`$2'))')dnl
forloop(`i',16,79,`define(`tmp_sha_tmp',eval(
	first(tmp_sha_W_`'eval(i-16)) ^ first(tmp_sha_W_`'eval(i-14)) ^
	first(tmp_sha_W_`'eval(i-8)) ^ first(tmp_sha_W_`'eval(i-3))))dnl
pushdef(`tmp_sha_W_'i,eval((tmp_sha_tmp << 1) 
			  | (tmp_sha_tmp >> 31 & 1)))')dnl
forloop(`i',0,4,`pushdef(`tmp_sha_A'i,choosei(i,`$1'))')dnl
pushdef(`tmp_sha_tmp')dnl
forloop(`i',0,79,`define(`tmp_sha_tmp',eval(
	((tmp_sha_A0 << 5) | (tmp_sha_A0 >> (32-5) & 0x1F))
	+ first(`sha_f_'eval(i/20)) + tmp_sha_A4 + first(`tmp_sha_W_'i)
	+ choosei(eval(i/20),`sha_K')))dnl
define(`tmp_sha_A4',tmp_sha_A3)dnl
define(`tmp_sha_A3',tmp_sha_A2)dnl
define(`tmp_sha_A2',eval((tmp_sha_A1 >> 2 & 0x3FFFFFFF) 
			 | (tmp_sha_A1 << 30)))dnl
define(`tmp_sha_A1',tmp_sha_A0)dnl
define(`tmp_sha_A0',tmp_sha_tmp)dnl
')dnl
forloop(`i',0,4,``'eval(first(`tmp_sha_A'i)
			  + choosei(i,`$1'))`'ifelse(i,4,,`,')')dnl
popdef(`tmp_sha_tmp')dnl
forloop(`i',0,79,`popdef(`tmp_sha_W_'i)')dnl
forloop(`i',0,4,`popdef(`tmp_sha_A'i)')dnl
')

The initial H values.
define(`sha_H',`0x67452301,0xefcdab89,0x98badcfe,0x10325476,0xc3d2e1f0')

Test cases:
ifdef(`RUNTESTS',`
sha_1(`sha_H',`0x61626380,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x18')
sha_1(quote(sha_1(`sha_H',quote(
	forloop(`i',0,13,`eval(0x61626364+(0x01010101*i)),')
	0x80000000, 0))),`0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x1C0')
')
