-- *************************************************************************
-- DISCLAIMER. THIS SOFTWARE WAS WRITTEN BY EMPLOYEES OF THE U.S.
-- GOVERNMENT AS A PART OF THEIR OFFICIAL DUTIES AND, THEREFORE, IS NOT
-- PROTECTED BY COPYRIGHT. HOWEVER, THIS SOFTWARE CODIFIES THE FINALIST
-- CANDIDATE ALGORITHMS (i.e., MARS, RC6tm, RIJNDAEL, SERPENT, AND
-- TWOFISH) IN THE ADVANCED ENCRYPTION STANDARD (AES) DEVELOPMENT EFFORT
-- SPONSORED BY THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY (NIST)
-- AND MAY BE PROTECTED BY ONE OR MORE FORMS OF INTELLECTUAL PROPERTY. THE
-- U.S. GOVERNMENT MAKES NO WARRANTY, EITHER EXPRESSED OR IMPLIED,
-- INCLUDING BUT NO LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
-- OR FITNESS FOR A PARTICULAR PURPOSE, REGARDING THIS SOFTWARE. THE U.S.
-- GOVERNMENT FURTHER MAKES NO WARRANTY THAT THIS SOFTWARE WILL NOT
-- INFRINGE ANY OTHER UNITED STATES OR FOREIGN PATENT OR OTHER
-- INTELLECTUAL PROPERTY RIGHT. IN NO EVENT SHALL THE U.S. GOVERNMENT BE
-- LIABLE TO ANYONE FOR COMPENSATORY, PUNITIVE, EXEMPLARY, SPECIAL,
-- COLLATERAL, INCIDENTAL, CONSEQUENTIAL, OR ANY OTHER TYPE OF DAMAGES IN
-- CONNECTION WITH OR ARISING OUT OF COPY OR USE OF THIS SOFTWARE.
-- *************************************************************************
--
-- File Name : controller_iter.vhdl
-- Author    : NSA
-- Date      : 04 Oct 1999
-- Project   : AES Candidate Evaluation --RC6 
-- Purpose   : This block runs the timing and data ready signals
-- Notes     :   
-- ===========================================================================

library ieee;
use ieee.std_logic_1164.all;
use WORK.rc6_pack.all;

-- ===========================================================================
-- =========================== Interface Description =========================
-- ===========================================================================

entity CONTROL_ITER is

  port (clock          :  in std_logic;
        reset          :  in std_logic;

        DATA_LOAD      :  in std_logic;   -- data start signal from interface
        CV_LOAD        :  in std_logic;   -- cv start signal from interface
        CTRL_ALG_DONE  :  in std_logic;   -- done signal from algorithm unit
        CTRL_KS_READY  :  in std_logic;   -- runup done, schedule ready

        CTRL_ALG_START :  out std_logic;  -- start encryption
        CTRL_KS_START  :  out std_logic   -- start key schedule
       
  );

end CONTROL_ITER;

architecture CONTROL_ITER_RTL of CONTROL_ITER is

-- ===========================================================================
-- =========================== Signal Definition =============================
-- ===========================================================================

signal STATE             : STATE_TYPE;
signal CTRL_KS_START_INT : std_logic;

begin

-- ===========================================================================
-- =========================== Data Movement =================================
-- ===========================================================================

CTRL_KS_START <= CTRL_KS_START_INT;

DATA_FLOW: process (clock, reset)

begin

 if reset = '1' then
   CTRL_KS_START_INT <= '0';

 elsif clock'event and clock = '1' then

   case STATE is

      when wait4ks =>

        if CTRL_KS_READY = '1' and DATA_LOAD = '1' then
          CTRL_KS_START_INT <= '1';
        else
          CTRL_KS_START_INT <= '0';
        end if;

      when ready =>

        if DATA_LOAD = '1' then
          CTRL_KS_START_INT <= '1';
        else
          CTRL_KS_START_INT <= '0';
        end if;

     when others =>

         CTRL_KS_START_INT <= '0';

   end case;

 end if; --if reset elsif clock'event
  
end process;


START_ALG: process ( clock, reset )

begin

   if reset = '1' then
    
      CTRL_ALG_START <= '0';

   elsif clock'event and clock = '1' then
 
      CTRL_ALG_START <= CTRL_KS_START_INT;

   end if; --if reset elsif clock'event
   
end process;

-- ===========================================================================
-- ========================= State Machine Control ===========================
-- ===========================================================================

STATE_FLOW : process ( clock, reset)

begin

   if reset = '1' then
     
      STATE <= nop;

   elsif CLOCK'event and CLOCK = '1' then
     
      case STATE is

         when nop =>

            if CV_LOAD = '1' then
               STATE <= wait4ks;
            else
               STATE <= STATE;
            end if;

         when wait4ks =>

            if CTRL_KS_READY = '1' then
               STATE <= ready;
            else
               STATE <= STATE;
            end if;

         when ready =>

            if CV_LOAD = '1' then
               STATE <= wait4ks;
            elsif DATA_LOAD = '1' then
               STATE <= busy;
            else
               STATE <= STATE;
            end if;

         when busy =>

            if CTRL_ALG_DONE = '1' then
               STATE <= ready;
            else
               STATE <= STATE;
            end if;

         when others =>

            STATE <= STATE;

      end case;

   end if;

end process;

end CONTROL_ITER_RTL;
 
 
