-- *************************************************************************
-- DISCLAIMER. THIS SOFTWARE WAS WRITTEN BY EMPLOYEES OF THE U.S.
-- GOVERNMENT AS A PART OF THEIR OFFICIAL DUTIES AND, THEREFORE, IS NOT
-- PROTECTED BY COPYRIGHT. HOWEVER, THIS SOFTWARE CODIFIES THE FINALIST
-- CANDIDATE ALGORITHMS (i.e., MARS, RC6tm, RIJNDAEL, SERPENT, AND
-- TWOFISH) IN THE ADVANCED ENCRYPTION STANDARD (AES) DEVELOPMENT EFFORT
-- SPONSORED BY THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY (NIST)
-- AND MAY BE PROTECTED BY ONE OR MORE FORMS OF INTELLECTUAL PROPERTY. THE
-- U.S. GOVERNMENT MAKES NO WARRANTY, EITHER EXPRESSED OR IMPLIED,
-- INCLUDING BUT NO LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
-- OR FITNESS FOR A PARTICULAR PURPOSE, REGARDING THIS SOFTWARE. THE U.S.
-- GOVERNMENT FURTHER MAKES NO WARRANTY THAT THIS SOFTWARE WILL NOT
-- INFRINGE ANY OTHER UNITED STATES OR FOREIGN PATENT OR OTHER
-- INTELLECTUAL PROPERTY RIGHT. IN NO EVENT SHALL THE U.S. GOVERNMENT BE
-- LIABLE TO ANYONE FOR COMPENSATORY, PUNITIVE, EXEMPLARY, SPECIAL,
-- COLLATERAL, INCIDENTAL, CONSEQUENTIAL, OR ANY OTHER TYPE OF DAMAGES IN
-- CONNECTION WITH OR ARISING OUT OF COPY OR USE OF THIS SOFTWARE.
-- *************************************************************************
--
-- File Name : cr_round_block.vhdl
-- Author    : NSA
-- Date      : 07 October 99
-- Project   : AES Candidate Evaluation --RC6
-- Purpose   : This block performs one iteration of subkey generation
-- Notes     : Only used in Pipelined case
-- ===========================================================================

library IEEE;
library DWDL;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use WORK.rc6_pack.all;

entity CR_ROUND_BLOCK is
  port (
    A       : in SLV_32;
    B       : in L_ARRAY_TYPE;
    S_IN    : in SLV_32;
    L_IN    : in L_ARRAY_TYPE;
    v       : in SLV_8;

    S_OUT   : out SLV_32;
    L_OUT   : out L_ARRAY_TYPE
  );
end CR_ROUND_BLOCK;

architecture rtl of CR_ROUND_BLOCK is 


signal S_OUT_INT : SLV_32;
signal L_MATRIX  : L_ARRAY_TYPE;


begin

     S_OUT_INT <= COMPUTE_KS_A(A, 
                               B,
                               S_IN,
                               v);  -- compute A 
                                    -- and update S(i)

     L_MATRIX    <= COMPUTE_KS_B(B,
                                 L_IN, 
                                 S_OUT_INT, 
                                 v);  -- compute B
                                      -- and update L(j)


   S_OUT <= S_OUT_INT;
   L_OUT <= L_MATRIX;

end rtl;
