-- *************************************************************************
-- DISCLAIMER. THIS SOFTWARE WAS WRITTEN BY EMPLOYEES OF THE U.S.
-- GOVERNMENT AS A PART OF THEIR OFFICIAL DUTIES AND, THEREFORE, IS NOT
-- PROTECTED BY COPYRIGHT. HOWEVER, THIS SOFTWARE CODIFIES THE FINALIST
-- CANDIDATE ALGORITHMS (i.e., MARS, RC6tm, RIJNDAEL, SERPENT, AND
-- TWOFISH) IN THE ADVANCED ENCRYPTION STANDARD (AES) DEVELOPMENT EFFORT
-- SPONSORED BY THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY (NIST)
-- AND MAY BE PROTECTED BY ONE OR MORE FORMS OF INTELLECTUAL PROPERTY. THE
-- U.S. GOVERNMENT MAKES NO WARRANTY, EITHER EXPRESSED OR IMPLIED,
-- INCLUDING BUT NO LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
-- OR FITNESS FOR A PARTICULAR PURPOSE, REGARDING THIS SOFTWARE. THE U.S.
-- GOVERNMENT FURTHER MAKES NO WARRANTY THAT THIS SOFTWARE WILL NOT
-- INFRINGE ANY OTHER UNITED STATES OR FOREIGN PATENT OR OTHER
-- INTELLECTUAL PROPERTY RIGHT. IN NO EVENT SHALL THE U.S. GOVERNMENT BE
-- LIABLE TO ANYONE FOR COMPENSATORY, PUNITIVE, EXEMPLARY, SPECIAL,
-- COLLATERAL, INCIDENTAL, CONSEQUENTIAL, OR ANY OTHER TYPE OF DAMAGES IN
-- CONNECTION WITH OR ARISING OUT OF COPY OR USE OF THIS SOFTWARE.
-- *************************************************************************

-- ===========================================================================
-- File Name : register_delay_s.vhdl
-- Author    : NSA
-- Date      : September 1999
-- Project   : Serpent interface block
-- Purpose   : This block stores the generated round keys for the pipelined 
--             case and dictates the motion of keys through the pipeline.
-- Notes     : Used for pipeline case only.
-- ===========================================================================

library ieee;
use ieee.std_logic_1164.all;
use WORK.serpent_pack.all;

-- ===========================================================================
-- =========================== Interface Description =========================
-- ===========================================================================

entity REGISTER_DELAY_W is

  port (clock    : in std_logic;   -- clock signal
        reset    : in std_logic;   -- active high reset (asynchronous)

        DATA_IN  : in W_TYPE;      -- input data bus

        DATA_OUT : out W_TYPE      -- output data bus

  );

end REGISTER_DELAY_W;

architecture REGISTER_DELAY_W_RTL of REGISTER_DELAY_W is

begin

-- ===========================================================================
-- =========================== Data Movement =================================
-- ===========================================================================

DATA_FLOW : process( clock, reset )

begin

   if reset = '1' then

      for INDEX in -8 to -1 loop                -- index all W inputs

         DATA_OUT(INDEX) <= ( others => '0' );  -- clear output signals

      end loop;

   elsif clock'event and clock = '1' then

      for INDEX in -8 to -1 loop                -- index all W inputs

         DATA_OUT(INDEX) <= DATA_IN(INDEX);     -- latch input data

      end loop;

   end if;

end process; -- DATA_FLOW

end REGISTER_DELAY_W_RTL;
