-- *************************************************************************
-- DISCLAIMER. THIS SOFTWARE WAS WRITTEN BY EMPLOYEES OF THE U.S.
-- GOVERNMENT AS A PART OF THEIR OFFICIAL DUTIES AND, THEREFORE, IS NOT
-- PROTECTED BY COPYRIGHT. HOWEVER, THIS SOFTWARE CODIFIES THE FINALIST
-- CANDIDATE ALGORITHMS (i.e., MARS, RC6tm, RIJNDAEL, SERPENT, AND
-- TWOFISH) IN THE ADVANCED ENCRYPTION STANDARD (AES) DEVELOPMENT EFFORT
-- SPONSORED BY THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY (NIST)
-- AND MAY BE PROTECTED BY ONE OR MORE FORMS OF INTELLECTUAL PROPERTY. THE
-- U.S. GOVERNMENT MAKES NO WARRANTY, EITHER EXPRESSED OR IMPLIED,
-- INCLUDING BUT NO LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
-- OR FITNESS FOR A PARTICULAR PURPOSE, REGARDING THIS SOFTWARE. THE U.S.
-- GOVERNMENT FURTHER MAKES NO WARRANTY THAT THIS SOFTWARE WILL NOT
-- INFRINGE ANY OTHER UNITED STATES OR FOREIGN PATENT OR OTHER
-- INTELLECTUAL PROPERTY RIGHT. IN NO EVENT SHALL THE U.S. GOVERNMENT BE
-- LIABLE TO ANYONE FOR COMPENSATORY, PUNITIVE, EXEMPLARY, SPECIAL,
-- COLLATERAL, INCIDENTAL, CONSEQUENTIAL, OR ANY OTHER TYPE OF DAMAGES IN
-- CONNECTION WITH OR ARISING OUT OF COPY OR USE OF THIS SOFTWARE.
-- *************************************************************************
-- ===========================================================================
-- File Name : create_t_block.vhdl
-- Author    : NSA
-- Date      : December 1999
-- Project   : AES Candidate Evaluation - MARS
-- Purpose   : This block runs the timing and data ready signals
-- Notes     :   
-- ===========================================================================
library IEEE;
library ieee;
use IEEE.std_logic_1164.all;
use WORK.mars_pack.all;

entity CREATE_T_BLOCK is
  port (T         : T_ARRAY_TYPE;
        j            : SLV_2;
        signal T_OUT : out T_ARRAY_TYPE 
    );
end CREATE_T_BLOCK;

architecture rtl of CREATE_T_BLOCK is 

  signal CREATE_T_FUNCT_out_tmp_created_by_csl : T_ARRAY_TYPE;

begin

    CREATE_T_FUNCT_out_tmp_created_by_csl <=
    CREATE_T_FUNCT(
	T => T,
	j => j);
    T_OUT <= CREATE_T_FUNCT_out_tmp_created_by_csl ;

end rtl;



