/*	CAST-256 Block Cypher Implementation
	Copyright (C) 1999, Daniel Roethlisberger

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at admin@roe.ch.
*/

#ifndef _CAST256_H
#define _CAST256_H

#define DWORD unsigned long

#define CAST_BLOCK_SIZE		16
#define CAST_USERKEY_SIZE	32
#define CAST_ROUNDS			12

// 128 bit BETA
typedef struct {
	DWORD A;
	DWORD B;
	DWORD C;
	DWORD D;
} BETA;

// 256 bit KAPPA
typedef struct {
	DWORD A;
	DWORD B;
	DWORD C;
	DWORD D;
	DWORD E;
	DWORD F;
	DWORD G;
	DWORD H;
} KAPPA;

// Exported Functions
void CAST256TableInit(void);
void CAST256Encrypt(BETA *Kr, BETA *Km, BETA *pData);
void CAST256Decrypt(BETA *Kr, BETA *Km, BETA *pData);
void CAST256KeyInit(BETA *Kr, BETA *Km, KAPPA userKey);

#endif /* _CAST256_H */

