/*	CAST-256 Strong Encryption Plugin for Back Orifice 2000
	Copyright (C) 1999, Daniel Roethlisberger

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at admin@roe.ch.
*/

#include <windows.h>
#include <plugins.h>
#include <bocomreg.h>
#include <iohandler.h>
#include <encryption.h>
#include "bo_cast.h"

CEncryptionHandler				*g_pEncHandler=NULL;
CIOHandler						*g_pIOHandler=NULL;
TYPEOF_RegisterCommand			*RegisterCommand=NULL;
TYPEOF_UnregisterCommand		*UnregisterCommand=NULL;
TYPEOF_RegisterClientMenu		*RegisterClientMenu=NULL;
TYPEOF_UnregisterClientMenu		*UnregisterClientMenu=NULL;
TYPEOF_IssueAuthCommandRequest	*IssueAuthCommandRequest=NULL;
TYPEOF_IssueAuthCommandReply	*IssueAuthCommandReply=NULL;
TYPEOF_ConnectAuthSocket		*ConnectAuthSocket=NULL;
TYPEOF_ListenAuthSocket			*ListenAuthSocket=NULL;
TYPEOF_InteractiveConnect		*InteractiveConnect=NULL;
TYPEOF_InteractiveListen		*InteractiveListen=NULL;

extern ENCRYPTION_ENGINE *GetCASTEncryptionEngine(void);

#pragma comment(linker,"/section:.data,RW")
#pragma comment(linker,"/section:.rdata,RW")
#pragma comment(linker,"/section:.edata,RW")

HINSTANCE g_hInstance;
BOOL g_bActive;
int g_nEncNum;

char g_szCASTEncryptOptions[] = "<**CFG**>CAST\0"
								"S[255]:" CAST_CONFIG_KEY_STRING "=\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
								"B:"      CAST_CONFIG_CBC_MODE   "=1\0";

BOOL WINAPI DllMain(HINSTANCE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			g_hInstance=hInst;
			break;
	}
	return TRUE;
}

BOOL InstallPlugin(PLUGIN_LINKAGE pl)
{
	g_bActive = TRUE;
	
	g_pEncHandler = pl.pEncryptionHandler;
	g_pIOHandler = pl.pIOHandler;
	RegisterCommand = pl.pRegisterCommand;
	UnregisterCommand = pl.pUnregisterCommand;
	IssueAuthCommandRequest = pl.pIssueAuthCommandRequest;
	IssueAuthCommandReply = pl.pIssueAuthCommandReply;
	ConnectAuthSocket = pl.pConnectAuthSocket;
	ListenAuthSocket = pl.pListenAuthSocket;
	RegisterClientMenu = pl.pRegisterClientMenu;
	UnregisterClientMenu = pl.pUnregisterClientMenu;
	InteractiveListen = pl.pInteractiveListen;
	InteractiveConnect = pl.pInteractiveConnect;
	
	if(g_pEncHandler)
	{
		g_nEncNum = g_pEncHandler->Insert(GetCASTEncryptionEngine());
		if(g_nEncNum < 0)
			return FALSE;
	}
	else
		return FALSE;

	return TRUE;
}

void TerminatePlugin(void)
{
	g_bActive = FALSE;
	if(g_pEncHandler)
	{
		g_pEncHandler->Remove(g_nEncNum);
	}
}

BOOL PluginVersion(PLUGIN_VERSION *ppv)
{
	ppv->svFilename = CAST_PLUGIN_FILENAME;
	ppv->svDescription = CAST_PLUGIN_DESCRIPTION;
	ppv->wVersionHi = CAST_PLUGIN_VERSION / 10;
	ppv->wVersionLo = CAST_PLUGIN_VERSION % 10;
	ppv->wBOVersionHi = 1;
	ppv->wBOVersionLo = 0;
	return TRUE;
}
