/*	CAST-256 Strong Encryption Plugin for Back Orifice 2000
	Copyright (C) 1999, Daniel Roethlisberger

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at admin@roe.ch.
*/

#ifndef MYCAST_H
#define MYCAST_H

#include <windows.h>
#include "cast256.h"

typedef struct {
	BETA CASTKr[CAST_ROUNDS];				// round rotation key set
	BETA CASTKm[CAST_ROUNDS];				// round mask key set
	KAPPA CASTUserKey;						// 256 bit user key
	char svCASTKey[256];					// up to 255 char key string
	BOOL bCASTCBC;							// CBC mode on or off
	BYTE CASTInitVect[CAST_BLOCK_SIZE];		// initialisation vector
} CAST_CTX;

int __cdecl CAST_Insert(void);
int __cdecl CAST_Remove(void);
char * __cdecl CAST_Query(void);
void * __cdecl CAST_Startup(void);
int __cdecl CAST_Shutdown(void *pInternal);
int __cdecl CAST_SetKey(void *pInternal, char *pKey);
char * __cdecl CAST_GetKey(void *pInternal);
BYTE * __cdecl CAST_Encrypt(void *pInternal, BYTE *pBuffer, int nBufLen, int *pnOutBufLen);
BYTE * __cdecl CAST_Decrypt(void *pInternal, BYTE *pBuffer, int nBufLen, int *pnOutBufLen);
int __cdecl CAST_CreateNewKeys(void *pInternal);
void __cdecl CAST_Free(void *pInternal, BYTE *pBuffer);

#endif // MYCAST_H