UNIT _Buffer;

 (* ********************************************************************** *)
 (*              Buffer Implementation for Feistel Ciphers                 *)
 (*                    Hereby distributed as OPEN SOURCE                   *)
 (*                 Copyrighted by (2001) Dutra de Lacerda                 *)
 (* ********************************************************************** *)
 (*                                                                        *)
 (* This code is Open Source in respect to the similar status of Blowfish  *)
 (* It is Copyrighted by "(2001) Dutra de Lacerda"                         *)
 (* You are allowed to use it with the usual conditions:                   *)
 (*   - Maintain this Copyright notice in the code.                        *)
 (*   - Make reference to this code, and Author, in your application.      *)
 (*   - Graciously communicate the Author your use of this code.           *)
 (*                                                                        *)
 (* ---------------------------------------------------------------------- *)
 (*                                                                        *)
 (*                           Finding the Author                           *)
 (*                           ~~~~~~~~~~~~~~~~~~                           *)
 (*  This units author can be reached via the following E-Mail addresses:  *)
 (*                                                                        *)
 (*      Via InterNet    : dulac@ip.pt                                     *)
 (*            ...and    : dutra.lacerda@mail.telepac.pt                   *)
 (*                                                                        *)
 (* ---------------------------------------------------------------------- *)
 (*                                                                        *)
 (*                          Finding New Versions                          *)
 (*                          ~~~~~~~~~~~~~~~~~~~~                          *)
 (*      My Home Site    : http://planeta.ip.pt/~ip200075                  *)
 (*            ...and    : http://www.factor-h.com                         *)
 (*                                                                        *)
 (*      Net Archives    : ftp://garbo.uwasa.fi/pc/crypt                   *)
 (*                      : ftp://garbo.uwasa.fi/pc/security                *)
 (*                      : ftp://ftp.elf.stuba.sk/pub/pc/security          *)
 (*                                                                        *)
 (* ---------------------------------------------------------------------- *)


    (****************************** Header ******************************)
    (****************************** Header ******************************)
    (****************************** Header ******************************)

INTERFACE

 (* ---------------------------------------------------------------------- *)
 (*                                                                        *)
 (*                             BUFFER OBJECT                              *)
 (*                                                                        *)
 (* ---------------------------------------------------------------------- *)

Type
    tBufferPtr = ^TBuffer;
    TBuffer = OBJECT
        pBuffer   : pointer;
        Constructor Init( NBlocks, BlockSize, MaskSize : Word );
        procedure   ReSizeToNBlocks( NBlocks, BlockSize, MaskSize : word );
        function    GetSizeInBytes   : longint;
        function    GetSizeInBlocks  : longint;
        Destructor  Done; VIRTUAL;
    PRIVATE
        _MaskValue      : word;
        _BufferSize     : word;
        _Error          : byte;
        _BlockSize      : word;
        _TotalBlocks    : word;
        _TotalSize      : word;
        _Available      : word;
    end;



    (******************************* Code *******************************)
    (******************************* Code *******************************)
    (******************************* Code *******************************)

IMPLEMENTATION

USES Dos;


 (* ---------------------------------------------------------------------- *)
 (*                                                                        *)
 (*                             Buffer Object                              *)
 (*                                                                        *)
 (* ---------------------------------------------------------------------- *)

    Constructor TBuffer.Init( var NBlocks, BlockSize, MaskSize : word );
        begin
        _MaskValue := (MaskSize-1);
        _Available := MaxAvail XOR _MaskValue;
        pBuffer    := NIL;     {Just in case...}
        ResizeToNBlocks ( NBlocks, BlockSize, MaskSize );
        end;

    procedure TBuffer.ResizeToNBlocks( NBlocks, BlockSize, MaskSize : word );
        var Available : word;    {Please Allow overflow}
            Wanted    : word;    {Please Allow overflow}
        begin
        _MaskValue := (MaskSize-1);

        If pBuffer <> NIL then
          begin
          FreeMem( pBuffer, _TotalSize);
          pBuffer    := NIL;     {Just in case...}
          end;

        Wanted    := ((NBlocks * BlockSize) + _MaskValue) XOR _MaskValue;
        Available := MaxAvail XOR _MaskValue;

        If (Available <= _MaskValue) then
          _Error := 255;
        If Available < Wanted then
          begin
          GetMem( pBuffer, Wanted );
          _error := 1;
          end;
        If Available > Wanted then
          begin
          GetMem( pBuffer, Available );
          _error := 0;
          end;

        _Available := MaxAvail;
        _BlockSize := BlockSize;
        _TotalSize := NBlocks * BlockSize;
        end;

    function TBuffer.GetSizeInBytes: longint;
        begin
        GetSizeInBytes := _TotalSize;
        end;

    function TBuffer.GetSizeInBlocks: longint;
        begin
        GetSizeInBlocks := _TotalBlocks;
        end;

    Destructor  TBuffer.Done;
        begin
        end;



 (* ---------------------------------------------------------------------- *)
 (*                                                                        *)
 (*                                  Main                                  *)
 (*                                                                        *)
 (* ---------------------------------------------------------------------- *)

begin
end.
