;-----------------------------------------------------------------------------
; DES test vectors - part of the DESPICable distribution
; Copyright 1994, 1996, 1997, 1998, 1999 Eric L. Smith
;
; WARNING: This software may be subject to export controls
;
; http://www.brouhaha.com/~eric/pic/
; http://www.brouhaha.com/~eric/crypto/
;
; DESPICable is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License version 2 as published by
; the Free Software Foundation.  Note that I am not granting permission to
; redistribute or modify DESPICable under the terms of any later version of
; the General Public License.
;
; This program is distributed in the hope that it will be useful (or at least
; amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
; Public License for more details.
;
; You should have received a copy of the GNU General Public License along with
; this program (in the file "COPYING"); if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; $Id: testvec.inc,v 1.2 1999/05/07 01:57:31 eric Exp $
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
; RAM definitions
;-----------------------------------------------------------------------------

	cblock
	vec_ptr: 2
	endc


;-----------------------------------------------------------------------------
; init_test_vec
;-----------------------------------------------------------------------------

init_test_vec:
	movlw	test_vec_tab&0xff
	movwf	vec_ptr
	movlw	test_vec_tab>>8
	movwf	vec_ptr+1
	return


;-----------------------------------------------------------------------------
; backup_test_vec_block
;-----------------------------------------------------------------------------

backup_test_vec_block:
	movlw	-blocklen
	addwf	vec_ptr
	btfss	STATUS,C
	decf	vec_ptr+1
	return


;-----------------------------------------------------------------------------
; skip_test_vec_block
;-----------------------------------------------------------------------------

skip_test_vec_block:
	movlw	blocklen
	addwf	vec_ptr
	btfsc	STATUS,C
	incf	vec_ptr+1
	return


;-----------------------------------------------------------------------------
; end_of_test_vec
;-----------------------------------------------------------------------------

end_of_test_vec:
	movf	vec_ptr,w
	xorlw	test_vec_tab_end&0xff
	btfss	STATUS,Z
	return
	movf	vec_ptr+1,w
	xorlw	test_vec_tab_end>>8
	return


;-----------------------------------------------------------------------------
; get one byte from test vector array, and advance pointer
;-----------------------------------------------------------------------------

get_test_vec_byte:

	movf	vec_ptr+1,w
	movwf	PCLATH
	movf	vec_ptr,w

	incf	vec_ptr
	btfsc	STATUS,Z
	incf	vec_ptr+1

        movwf   PCL


;-----------------------------------------------------------------------------
; copies keylen bytes of data from the test vector array into the RAM
; pointed to by FSR.
;
; on exit, the test vector pointer is increased by keylen, but FSR is
; unchanged
;
; uses count
;-----------------------------------------------------------------------------

get_test_vec_key:
        movlw   keylen
        movwf   count
gtvk0:	call    get_test_vec_byte
        movwf   INDF
        incf    FSR
        decfsz  count
        goto    gtvk0
        movlw   -keylen
        addwf   FSR
        return


;-----------------------------------------------------------------------------
; copies blocklen bytes of data from the test vector array into the RAM
; pointed to by FSR.
;
; on exit, the test vector pointer is increased by blocklen, but FSR is
; unchanged
;
; uses count
;-----------------------------------------------------------------------------

get_test_vec_block:
        movlw   blocklen
        movwf   count
gtvb0:	call    get_test_vec_byte
        movwf   INDF
        incf    FSR
        decfsz  count
        goto    gtvb0
        movlw   -blocklen
        addwf   FSR
        return


;-----------------------------------------------------------------------------
; compares blocklen bytes of data from the test vector array to the RAM
; pointed to by FSR.
;
; on exit, the test vector pointer is increased by blocklen, but FSR is
; unchanged.  The zero flag will be set if the test vector is equal to the
; RAM value.
;
; uses count, temp
;-----------------------------------------------------------------------------

compare_test_vec_block:
        movlw   blocklen
        movwf   count
	clrf	temp
ctvb0:	call    get_test_vec_byte
        xorwf   INDF,W
	iorwf	temp
        incf    FSR
        decfsz  count
        goto    ctvb0
        movlw   -blocklen
        addwf   FSR
	movf	temp		; set Z flag appropriately
        return


;-----------------------------------------------------------------------------
; and finally, the actual test vectors
;-----------------------------------------------------------------------------

test_vec_tab:

; These three test vectors are from desCore-2 by Dana L. How.
; ftp://ftp.funet.fi/pub/crypt/cryptography/symmetric/des/desCore-2-How.tar.gz
; He attributes them to some code from MIT (probably part of Kerberos).
; A fourth test vector from desCore is identical to the first one from
; Handbook of Applied Cryptography, below.

	dt      0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x80 ; key
        dt      0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 ; plaintext
        dt      0x9c,0xc6,0x2d,0xf4,0x3b,0x6e,0xed,0x74 ; ciphertext

	dt      0x80,0x01,0x01,0x01,0x01,0x01,0x01,0x01 ; key
	dt      0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40 ; plaintext
	dt      0xa3,0x80,0xe0,0x2a,0x6b,0xe5,0x46,0x96 ; ciphertext

        dt      0x08,0x19,0x2a,0x3b,0x4c,0x5d,0x6e,0x7f ; key
        dt      0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 ; plaintext
        dt      0x25,0xdd,0xac,0x3e,0x96,0x17,0x64,0x67 ; ciphertext


; This is from
;	Applied Cryptography Second Edition, p. 631
;	Bruce Schneier
;	John Wiley & Sons, Inc. 1996
;	ISBN 0-471-12845-7
;	http://www.counterpane.com/applied.html

	dt	0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef ; key
	dt	0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xe7 ; plaintext
	dt	0xc9,0x57,0x44,0x25,0x6a,0x5e,0xd3,0x1d ; ciphertext


; These three are from
;	Handbook of Applied Cryptography
;	Menezes, van Oorschot, and Vanstone
;	CRC Press, October 1996
;	ISBN 0-8493-8253-7
;	http://www.dms.auburn.edu/hac/

        dt      0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef ; key
        dt      "Now is t"                              ; plaintext
        dt      0x3f,0xa4,0x0e,0x8a,0x98,0x4d,0x48,0x15 ; ciphertext
	
        dt      0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef ; key
	dt	"he time "                              ; plaintext
	dt	0x6a,0x27,0x17,0x87,0xab,0x88,0x83,0xf9 ; ciphertext
	
        dt      0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef ; key       
	dt	"for all "                              ; plaintext 
	dt	0x89,0x3d,0x51,0xec,0x4b,0x56,0x3b,0x53 ; ciphertext


; 19 test vectors from April 1979 Byte magazine, page 124

	dt	0x7c,0xa1,0x10,0x45,0x4a,0x1a,0x6e,0x57 ; key       
	dt	0x01,0xa1,0xd6,0xd0,0x39,0x77,0x67,0x42 ; plaintext 
	dt	0x69,0x0f,0x5b,0x0d,0x9a,0x26,0x93,0x9b ; ciphertext

	dt	0x01,0x31,0xd9,0x61,0x9d,0xc1,0x37,0x6e ; key       
	dt	0x5c,0xd5,0x4c,0xa8,0x3d,0xef,0x57,0xda ; plaintext 
	dt	0x7a,0x38,0x9d,0x10,0x35,0x4b,0xd2,0x71 ; ciphertext

	dt	0x07,0xa1,0x13,0x3e,0x4a,0x0b,0x26,0x86 ; key       
	dt	0x02,0x48,0xd4,0x38,0x06,0xf6,0x71,0x72 ; plaintext 
	dt	0x86,0x8e,0xbb,0x51,0xca,0xb4,0x59,0x9a ; ciphertext

	dt	0x38,0x49,0x67,0x4c,0x26,0x02,0x31,0x9e ; key       
	dt	0x51,0x45,0x4b,0x58,0x2d,0xdf,0x44,0x0a ; plaintext 
	dt	0x71,0x78,0x87,0x6e,0x01,0xf1,0x9b,0x2a ; ciphertext

	dt	0x04,0xb9,0x15,0xba,0x43,0xfe,0xb5,0xb6 ; key       
	dt	0x42,0xfd,0x44,0x30,0x59,0x57,0x7f,0xa2 ; plaintext 
	dt	0xaf,0x37,0xfb,0x42,0x1f,0x8c,0x40,0x95 ; ciphertext

	dt	0x01,0x13,0xb9,0x70,0xfd,0x34,0xf2,0xce ; key       
	dt	0x05,0x9b,0x5e,0x08,0x51,0xcf,0x14,0x3a ; plaintext 
	dt	0x86,0xa5,0x60,0xf1,0x0e,0xc6,0xd8,0x5b ; ciphertext

; By this point we actually have full code coverage (including all
; S-box entries).

	dt	0x01,0x70,0xf1,0x75,0x46,0x8f,0xb5,0xe6 ; key       
	dt	0x07,0x56,0xd8,0xe0,0x77,0x47,0x61,0xd2 ; plaintext 
	dt	0x0c,0xd3,0xda,0x02,0x00,0x21,0xdc,0x09 ; ciphertext

	dt	0x43,0x29,0x7f,0xad,0x38,0xe3,0x73,0xfe ; key       
	dt	0x76,0x25,0x14,0xb8,0x29,0xbf,0x48,0x6a ; plaintext 
	dt	0xea,0x67,0x6b,0x2c,0xb7,0xdb,0x2b,0x7a ; ciphertext

	dt	0x07,0xa7,0x13,0x70,0x45,0xda,0x2a,0x16 ; key       
	dt	0x3b,0xdd,0x11,0x90,0x49,0x37,0x28,0x02 ; plaintext 
	dt	0xdf,0xd6,0x4a,0x81,0x5c,0xaf,0x1a,0x0f ; ciphertext

	dt	0x04,0x68,0x91,0x04,0xc2,0xfd,0x3b,0x2f ; key       
	dt	0x26,0x95,0x5f,0x68,0x35,0xaf,0x60,0x9a ; plaintext 
	dt	0x5c,0x51,0x3c,0x9c,0x48,0x86,0xc0,0x88 ; ciphertext

	dt	0x37,0xd0,0x6b,0xb5,0x16,0xcb,0x75,0x46 ; key       
	dt	0x16,0x4d,0x5e,0x40,0x4f,0x27,0x52,0x32 ; plaintext 
	dt	0x0a,0x2a,0xee,0xae,0x3f,0xf4,0xab,0x77 ; ciphertext

	dt	0x1f,0x08,0x26,0x0d,0x1a,0xc2,0x46,0x5e ; key       
	dt	0x6b,0x05,0x6e,0x18,0x75,0x9f,0x5c,0xca ; plaintext 
	dt	0xef,0x1b,0xf0,0x3e,0x5d,0xfa,0x57,0x5a ; ciphertext

	dt	0x58,0x40,0x23,0x64,0x1a,0xba,0x61,0x76 ; key       
	dt	0x00,0x4b,0xd6,0xef,0x09,0x17,0x60,0x62 ; plaintext 
	dt	0x88,0xbf,0x0d,0xb6,0xd7,0x0d,0xee,0x56 ; ciphertext

	dt	0x02,0x58,0x16,0x16,0x46,0x29,0xb0,0x07 ; key       
	dt	0x48,0x0d,0x39,0x00,0x6e,0xe7,0x62,0xf2 ; plaintext 
	dt	0xa1,0xf9,0x91,0x55,0x41,0x02,0x0b,0x56 ; ciphertext

	dt	0x49,0x79,0x3e,0xbc,0x79,0xb3,0x25,0x8f ; key       
	dt	0x43,0x75,0x40,0xc8,0x69,0x8f,0x3c,0xfa ; plaintext 
	dt	0x6f,0xbf,0x1c,0xaf,0xcf,0xfd,0x05,0x56 ; ciphertext

	dt	0x4f,0xb0,0x5e,0x15,0x15,0xab,0x73,0xa7 ; key       
	dt	0x07,0x2d,0x43,0xa0,0x77,0x07,0x52,0x92 ; plaintext 
	dt	0x2f,0x22,0xe4,0x9b,0xab,0x7c,0xa1,0xac ; ciphertext

	dt	0x49,0xe9,0x5d,0x6d,0x4c,0xa2,0x29,0xbf ; key       
	dt	0x02,0xfe,0x55,0x77,0x81,0x17,0xf1,0x2a ; plaintext 
	dt	0x5a,0x6b,0x61,0x2c,0xc2,0x6c,0xce,0x4a ; ciphertext

	dt	0x01,0x83,0x10,0xdc,0x40,0x9b,0x26,0xd6 ; key       
	dt	0x1d,0x9d,0x5c,0x50,0x18,0xf7,0x28,0xc2 ; plaintext 
	dt	0x5f,0x4c,0x03,0x8e,0xd1,0x2b,0x2e,0x41 ; ciphertext

	dt	0x1c,0x58,0x7f,0x1c,0x13,0x92,0x4f,0xef ; key       
	dt	0x30,0x55,0x32,0x28,0x6d,0x6f,0x29,0x5a ; plaintext 
	dt	0x63,0xfa,0xc0,0xd0,0x34,0xd9,0xf7,0x93 ; ciphertext
	  
test_vec_tab_end:



