/**<PRE>
 * SHA0.java - An implementation of the SHA-0 Algorithm
*  <P>
*  Coded Mr. Tines &lt;tines@windsong.demon.co.uk&gt; 1998
*  and released into the public domain
*  <P>
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*  <PRE>
*
*      Test Vectors (from FIPS PUB 180-1)
*      "abc"
*      0164b8a9 14cd2a5e 74c4f7ff 082c4d97 f1edf880
*      "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"
*      d2516ee1 acfa5baf 33dfc1c4 71e43844 9ef134c8
*      A million repetitions of "a"
*      3232affa 48628a26 653b5aaa 44541fd9 0d690603
*
*</PRE>
* @author Mr. Tines
* @version 1.0 23-Dec-1998
*/

package uk.co.demon.windsong.crypt.mda;

public class SHA0 extends SHA1
{
    /**
    * simple constructor
    */
    public SHA0()
    {
        super(false);
    }
   /**
    * test driver
    */
    public static void main(String[] args)
    {
        SHAselfTest();
    }

	/**
	* perfoms a self-test - spits out the test vector outputs on System.out
	*/
    public static void SHAselfTest()
    {
        int i, j;
        SHA0 s = new SHA0();
        // This line may be safely deleted, its to make it easy to see
        // the output of the program.

        System.out.println("SHA-0 Test PROGRAM.");
        System.out.println("This code runs the test vectors through the code.");

/*      "abc"
        0164b8a9 14cd2a5e 74c4f7ff 082c4d97 f1edf880 */

        System.out.println("First test is 'abc'");
        String z = "abc";
        s.init();
        s.update((byte) 'a');
        s.update((byte) 'b');
        s.update((byte) 'c');
        s.finish();
        System.out.println(s.digout());
        System.out.println("0164b8a9 14cd2a5e 74c4f7ff 082c4d97 f1edf880");


/*      "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"
        d2516ee1 acfa5baf 33dfc1c4 71e43844 9ef134c8 */

        System.out.println("Next Test is 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'");
        z = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
        s.init();
        for( i=0; i<z.length(); ++i)
        {
        	s.update((byte) z.charAt(i));
        }
        s.finish();
        System.out.println(s.digout());
        System.out.println("d2516ee1 acfa5baf 33dfc1c4 71e43844 9ef134c8");

/*      A million repetitions of "a"
        33232affa 48628a26 653b5aaa 44541fd9 0d690603 */
   	  long startTime = 0 - System.currentTimeMillis();

        System.out.println("Last test is 1 million 'a' characters.");
        s.init();
        for (i = 0; i < 1000000; i++)
            s.update((byte) 'a');
        s.finish();
        System.out.println(s.digout());
        System.out.println("3232affa 48628a26 653b5aaa 44541fd9 0d690603");
        startTime += System.currentTimeMillis();
        double d = ((double)startTime)/1000.0;
        System.out.println(" done, elapsed time = "+d);
	}
}