/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

final class JceSecurity {
    private JceSecurity() {
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object object;
        Class clazz = null;
        Provider provider = null;
        if (string3 != null) {
            provider = Security.getProvider(string3);
            if (provider == null) {
                throw new NoSuchProviderException("No such provider: " + string3);
            }
            clazz = JceSecurity.getImplClass(string, string2, provider);
        } else {
            object = Security.getProviders();
            boolean bl = false;
            int n = 0;
            while (n < ((Provider[])object).length && !bl) {
                try {
                    clazz = JceSecurity.getImplClass(string, string2, object[n]);
                    bl = true;
                    provider = object[n];
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
                ++n;
            }
            if (!bl) {
                throw new NoSuchAlgorithmException("Algorithm " + string + " not available");
            }
        }
        object = null;
        try {
            object = Class.forName("javax.crypto." + string2 + "Spi");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException(classNotFoundException.getMessage());
        }
        if (!JceSecurity.checkSuperclass(clazz, (Class)object)) {
            throw new NoSuchAlgorithmException("Class " + clazz.getName() + " configured for " + string2 + " not a " + string2);
        }
        try {
            Object t = clazz.newInstance();
            return new Object[]{t, provider};
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("Class " + clazz.getName() + " configured for " + string2 + " cannot be instantiated: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("Class " + clazz.getName() + " configured for " + string2 + " cannot be accessed: " + illegalAccessException.getMessage());
        }
    }

    private static Class getImplClass(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        Object object;
        Class<?> clazz = null;
        String string3 = String.valueOf(string2) + "." + string;
        String string4 = JceSecurity.getProviderProperty(string3, provider);
        if (string4 == null) {
            object = JceSecurity.getStandardName(string, string2, provider);
            if (object != null) {
                string3 = String.valueOf(string2) + "." + (String)object;
            }
            if (object == null || (string4 = JceSecurity.getProviderProperty(string3, provider)) == null) {
                throw new NoSuchAlgorithmException("No such algorithm: " + string);
            }
        }
        try {
            object = provider.getClass().getClassLoader();
            clazz = object == null ? Class.forName(string4) : ((ClassLoader)object).loadClass(string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("Class " + string4 + " configured for " + string2 + " not found: " + classNotFoundException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new NoSuchAlgorithmException("Class " + string4 + " configured for " + string2 + " cannot be accessed: " + securityException.getMessage());
        }
        return clazz;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = ((Properties)provider).getProperty(string);
        if (string2 != null) {
            return string2;
        }
        Enumeration enumeration = ((Hashtable)provider).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string3)) continue;
            return ((Properties)provider).getProperty(string3);
        }
        return null;
    }

    private static String getStandardName(String string, String string2, Provider provider) {
        return JceSecurity.getProviderProperty("Alg.Alias." + string2 + "." + string, provider);
    }
}

