/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv;
    private int effectiveKeyBits;

    public RC2ParameterSpec(int n) {
        this.effectiveKeyBits = n;
    }

    public RC2ParameterSpec(int n, byte[] byArray) {
        this(n, byArray, 0);
    }

    public RC2ParameterSpec(int n, byte[] byArray, int n2) {
        this.effectiveKeyBits = n;
        if (byArray == null) {
            throw new IllegalArgumentException("IV missing");
        }
        int n3 = 8;
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("IV too short");
        }
        this.iv = new byte[n3];
        System.arraycopy(byArray, n2, this.iv, 0, n3);
    }

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public byte[] getIV() {
        if (this.iv != null) {
            return (byte[])this.iv.clone();
        }
        return null;
    }
}

