/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

final class JceSecurity {
    private JceSecurity() {
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        String string4 = null;
        String string5 = null;
        Class<?> clazz = null;
        String string6 = null;
        Provider provider = null;
        try {
            Object object;
            if (string3 != null) {
                ClassLoader classLoader;
                provider = Security.getProvider(string3);
                if (provider == null) {
                    throw new NoSuchProviderException("No such provider: " + string3);
                }
                String string7 = String.valueOf(string2) + "." + string;
                string5 = JceSecurity.getProviderProperty(string7, provider);
                if (string5 == null) {
                    string4 = JceSecurity.getStandardName(string, string2, provider);
                    if (string4 != null) {
                        string7 = String.valueOf(string2) + "." + string4;
                    }
                    if (string4 == null || (string5 = JceSecurity.getProviderProperty(string7, provider)) == null) {
                        throw new NoSuchAlgorithmException("No such algorithm: " + string + " for provider " + string3);
                    }
                }
                clazz = (classLoader = provider.getClass().getClassLoader()) == null ? Class.forName(string5) : classLoader.loadClass(string5);
            } else {
                object = Security.getProviders();
                int n = 0;
                while (n < ((Provider[])object).length && string4 == null) {
                    string4 = JceSecurity.getStandardName(string, string2, object[n]);
                    ++n;
                }
                n = 0;
                boolean bl = false;
                String string8 = String.valueOf(string2) + "." + string;
                if (string4 != null) {
                    string6 = String.valueOf(string2) + "." + string4;
                }
                while (n < ((Provider[])object).length && !bl) {
                    string5 = JceSecurity.getProviderProperty(string8, object[n]);
                    if (string5 == null && string6 != null) {
                        string5 = JceSecurity.getProviderProperty(string6, object[n]);
                    }
                    if (string5 != null) {
                        try {
                            ClassLoader classLoader = object[n].getClass().getClassLoader();
                            clazz = classLoader == null ? Class.forName(string5) : classLoader.loadClass(string5);
                            bl = true;
                            provider = object[n];
                        }
                        catch (SecurityException securityException) {}
                    }
                    ++n;
                }
                if (!bl) {
                    throw new NoSuchAlgorithmException("Algorithm " + string + " not available");
                }
            }
            object = Class.forName("javax.crypto." + string2 + "Spi");
            if (JceSecurity.checkSuperclass(clazz, (Class)object)) {
                Object obj = clazz.newInstance();
                return new Object[]{obj, provider};
            }
            throw new NoSuchAlgorithmException("Class configured for " + string2 + ": " + string5 + " not a " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("Class configured for " + string2 + " (provider: " + string3 + ")" + " cannot be found" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("Class " + string5 + " configured for " + string2 + " (provider: " + string3 + ") cannot be instantiated" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("Class " + string5 + " configured for " + string2 + " (provider: " + string3 + ") cannot be accessed" + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new NoSuchAlgorithmException("Class " + string5 + " configured for " + string2 + " (provider: " + string3 + ") cannot be accessed" + securityException.getMessage());
        }
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = ((Properties)provider).getProperty(string);
        if (string2 != null) {
            return string2;
        }
        Enumeration enumeration = ((Hashtable)provider).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string3)) continue;
            return ((Properties)provider).getProperty(string3);
        }
        return null;
    }

    private static String getStandardName(String string, String string2, Provider provider) {
        return JceSecurity.getProviderProperty("Alg.Alias." + string2 + "." + string, provider);
    }
}

