/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.JceSecurity;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private Provider provider;
    private CipherSpi cipherSpi;
    private String transformation;
    private boolean initialized = false;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialize");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("null input buffer");
        }
        return this.cipherSpi.engineDoFinal(byArray, 0, byArray.length);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0, byArray, n);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized!");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final int getBlockSize() {
        return this.cipherSpi.engineGetBlockSize();
    }

    public final byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String[] stringArray;
        Object[] objectArray;
        boolean bl;
        boolean bl2;
        block15: {
            bl2 = false;
            bl = false;
            objectArray = null;
            int n = 0;
            stringArray = new String[3];
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            try {
                while (stringTokenizer.hasMoreTokens() && n < 3) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
                if (n == 0 || n == 2 || stringTokenizer.hasMoreTokens()) {
                    throw new NoSuchAlgorithmException("Wrong transformation format");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NoSuchAlgorithmException("Wrong transformation format");
            }
            try {
                if (n == 3) {
                    try {
                        objectArray = JceSecurity.getImpl(string, "Cipher", null);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        try {
                            objectArray = JceSecurity.getImpl(String.valueOf(stringArray[0]) + "/" + stringArray[1], "Cipher", null);
                            bl = true;
                            break block15;
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                            try {
                                objectArray = JceSecurity.getImpl(String.valueOf(stringArray[0]) + "//" + stringArray[2], "Cipher", null);
                                bl2 = true;
                                break block15;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                                objectArray = JceSecurity.getImpl(stringArray[0], "Cipher", null);
                                bl2 = true;
                                bl = true;
                            }
                        }
                    }
                    break block15;
                }
                objectArray = JceSecurity.getImpl(string, "Cipher", null);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
            }
        }
        Cipher cipher = new Cipher((CipherSpi)objectArray[0], (Provider)objectArray[1], string);
        if (bl2) {
            cipher.cipherSpi.engineSetMode(stringArray[1]);
        }
        if (bl) {
            cipher.cipherSpi.engineSetPadding(stringArray[2]);
        }
        return cipher;
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = null;
        int n = 0;
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            while (stringTokenizer.hasMoreTokens() && n < 3) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            if (n == 0 || n == 2 || stringTokenizer.hasMoreTokens()) {
                throw new NoSuchAlgorithmException("Wrong transformation format");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchAlgorithmException("Wrong transformation format");
        }
        if (n == 3) {
            try {
                objectArray = JceSecurity.getImpl(string, "Cipher", string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    objectArray = JceSecurity.getImpl(String.valueOf(stringArray[0]) + "/" + stringArray[1], "Cipher", string2);
                    bl2 = true;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    try {
                        objectArray = JceSecurity.getImpl(String.valueOf(stringArray[0]) + "//" + stringArray[2], "Cipher", string2);
                        bl = true;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                        objectArray = JceSecurity.getImpl(stringArray[0], "Cipher", string2);
                        bl = true;
                        bl2 = true;
                    }
                }
            }
        } else {
            objectArray = JceSecurity.getImpl(string, "Cipher", string2);
        }
        Cipher cipher = new Cipher((CipherSpi)objectArray[0], (Provider)objectArray[1], string);
        if (bl) {
            cipher.cipherSpi.engineSetMode(stringArray[1]);
        }
        if (bl2) {
            cipher.cipherSpi.engineSetPadding(stringArray[2]);
        }
        return cipher;
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Input size must be equal to or greater than zero");
        }
        return this.cipherSpi.engineGetOutputSize(n);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, key, new SecureRandom());
        this.initialized = true;
    }

    public final void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, key, secureRandom);
        this.initialized = true;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, new SecureRandom());
        this.initialized = true;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, secureRandom);
        this.initialized = true;
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("null input buffer");
        }
        return this.cipherSpi.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n2 == 0) {
            return null;
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher has not been initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, n3);
    }
}

