#!/bin/ksh

## MBC2 KornShell (ksh93) implementation.

## Algorithm developed by Michael W. Bombardieri <bombardierix@gmail.com>

## Version 0.0.1 (2006.10.14)

## The following code is released into the public domain by its author.

## BUYER BEWARE: This code is extremely slow.


function set_key
{
	typeset blk;
	typeset f;
	typeset i;

	for (( i=0; i<588; i++ )); do	# initialise key[]
		key[$i]=$(( $i % 256 ));
	done;

	# initialise blk[] using first 64 key bits
	f[0]=$(( ($1 & 0xff000000) >> 24 ));
	f[1]=$(( ($2 & 0xff000000) >> 24 ));
	f[2]=$(( ($3 & 0xff000000) >> 24 ));
	f[3]=$(( ($4 & 0xff000000) >> 24 ));

	blk[0]=$(( ${f[0]} ^ ${f[1]} ));
	blk[1]=$(( ${f[0]} ^ ${f[2]} ));
	blk[2]=$(( ${f[0]} ^ ${f[3]} ));
	blk[3]=$(( ${f[1]} ^ ${f[2]} ));
	blk[4]=$(( ${f[1]} ^ ${f[3]} ));
	blk[5]=$(( ${f[2]} ^ ${f[3]} ));
	blk[6]=${f[0]};
	blk[7]=${f[1]};
	blk[8]=${f[2]};
	blk[9]=${f[3]};

	f[0]=$(( ($1 & 0xff0000) >> 16 ));
	f[1]=$(( ($2 & 0xff0000) >> 16 ));
	f[2]=$(( ($3 & 0xff0000) >> 16 ));
	f[3]=$(( ($4 & 0xff0000) >> 16 ));

	blk[10]=$(( ${blk[0]} ^ ${f[0]} ));
	blk[11]=$(( ${blk[1]} ^ ${f[1]} ));
	blk[12]=$(( ${blk[2]} ^ ${f[2]} ));
	blk[13]=$(( ${blk[3]} ^ ${f[3]} ));
	blk[14]=$(( ${f[0]} ^ ${f[1]} ));
	blk[15]=$(( ${f[2]} ^ ${f[3]} ));

	for (( i=0; i<588; i++ )); do	# primary key mix
		key[$i]=$(( ${key[$i]} ^ ((${blk[$i % 16]} + ${f[$i % 4]}) % 256) ));
		f[$i % 4]=${key[$i]};
	done;

	# use the next 64 key bits
	blk[0]=$(( ${f[0]} ^ ${f[1]} ));
	blk[1]=$(( ${f[0]} ^ ${f[2]} ));
	blk[2]=$(( ${f[0]} ^ ${f[3]} ));
	blk[3]=$(( ${f[1]} ^ ${f[2]} ));
	blk[4]=$(( ${f[1]} ^ ${f[3]} ));
	blk[5]=$(( ${f[2]} ^ ${f[3]} ));

	f[0]=$(( ($1 & 0xff00) >> 8 ));
	f[1]=$(( ($2 & 0xff00) >> 8 ));
	f[2]=$(( ($3 & 0xff00) >> 8 ));
	f[3]=$(( ($4 & 0xff00) >> 8 ));

	blk[6]=$(( ${f[0]} ^ ${blk[2]} ));
	blk[7]=$(( ${f[1]} ^ ${blk[3]} ));
	blk[8]=$(( ${f[2]} ^ ${blk[4]} ));
	blk[9]=$(( ${f[3]} ^ ${blk[5]} ));

	f[0]=$(( $1 & 0xff ));
	f[1]=$(( $2 & 0xff ));
	f[2]=$(( $3 & 0xff ));
	f[3]=$(( $4 & 0xff ));

	blk[10]=$(( ${blk[6]} ^ ${f[0]} ));
	blk[11]=$(( ${blk[7]} ^ ${f[1]} ));
	blk[12]=$(( ${blk[8]} ^ ${f[2]} ));
	blk[13]=$(( ${blk[9]} ^ ${f[3]} ));
	blk[14]=$(( ${f[0]} ^ ${f[2]} ));
	blk[15]=$(( ${f[1]} ^ ${f[3]} ));

	f[1]=$(( ${f[1]} ^ ${f[0]} ));
	f[2]=$(( ${f[2]} ^ ${f[0]} ));
	f[3]=$(( ${f[3]} ^ ${f[0]} ));

	for (( i=0; i<588; i++ )); do	# secondary key mix
		key[$i]=$(( (${key[$i]} + (${blk[$i % 16]} ^ ${f[$i % 4]})) % 256 ));
		f[$i % 4]=${key[$i]};		
	done;
}

function encrypt
{
	typeset blk;	# data block bits
	typeset out_blk;# returned ciphertext
	typeset sk;	# substitution key
	typeset tk;	# transposition key
	typeset pc;	# prev. ciphertext
	typeset bi;	# index into blk[]
	typeset ki;	# index into key[]
	typeset t; 	# temp. for bit swap etc.
	typeset i;
	typeset j;
	
	for (( i=31; i>=0; i-- )); do		# in_blk[] --> blk[]
		blk[31 - $i]=$(( ($1  & (1 << $i)) >> $i ));
		blk[63 - $i]=$(( ($2  & (1 << $i)) >> $i ));
	done;
	
	for (( i=0; i<16; i++ )); do		# round loop
		ki=$(( 36 * $i ));
		for (( j=0; j<48; j++ )); do	# build round key
			t=${key[$ki + $j]};
			tk[$j]=$(( $t >> 2 ));
			sk[$j]=$(( ($t & 1) ^ (($t & 2) >> 1) ));
		done;
		for (( j=0; j<16; j++ )); do	# expand tk
			tk[$j + 48]=$(( (${tk[$j]} + ${tk[$j + 1]}) % 64 ));
		done;
		
		for (( j=0; j<64; j++ )); do	# transposition loop
			bi=${tk[$j]};
			t=${blk[$j]};
			blk[$j]=${blk[$bi]};
			blk[$bi]=$t;
		done;

		pc=0;
		for (( j=0; j<48; j++ )); do	# substitution loop
			t=${sk[$j]};
			blk[$j]=$(( ${blk[$j]} ^ (($pc + $t) % 2) ));
			pc=${blk[$j]};
		done;		

		for (( j=48; j<64; j++ )); do	# feedback loop
			blk[$j]=$(( ${blk[$j]} ^ ${blk[$j - 36]} ));
		done;
	done;

	out_blk[0]=0;
	out_blk[1]=0;

	for (( i=0; i<32; i++ )); do	# rebuild data block
		out_blk[0]=$(( ${out_blk[0]} + (${blk[$i]} << (31 - $i)) ));
		out_blk[1]=$(( ${out_blk[1]} + (${blk[$i + 32]} << (31 - $i)) ));
	done;

	printf "0x%08lX 0x%08lX\n" ${out_blk[0]} ${out_blk[1]};
}

function decrypt
{
	typeset blk;	# data block bits
	typeset new_blk;# recovered plaintext
	typeset sk;	# substitution key
	typeset tk;	# transposition key
	typeset bi;	# index into blk[]
	typeset ki;	# index into key[]
	typeset t; 	# temp. for bit swap etc.
	typeset i;
	typeset j;

	blk[0]=0;	# prev.ciphertext of 1st data bit
	for (( i=31; i>=0; i-- )); do		# in_blk[] --> blk[]
		blk[32 - $i]=$(( ($1  & (1 << $i)) >> $i ));
		blk[64 - $i]=$(( ($2  & (1 << $i)) >> $i ));
	done;

	for (( i=15; i>=0; i-- )); do		# round loop
		ki=$(( 36 * $i ));
		for (( j=0; j<48; j++ )); do	# build round key
			t=${key[$ki + $j]};
			tk[$j]=$(( $t >> 2 ));
			sk[$j]=$(( ($t & 1) ^ (($t & 2) >> 1) ));
		done;
		for (( j=0; j<16; j++ )); do	# expand tk
			tk[$j + 48]=$(( (${tk[$j]} + ${tk[$j + 1]}) % 64 ));
		done;

		for (( j=64; j>=49; j-- )); do	# undo feedback loop
			blk[$j]=$(( ${blk[$j]} ^ ${blk[$j - 36]} ));
		done;
	
		for (( j=48; j>=1; j-- )); do	# undo substitution loop
			t=${sk[$j - 1]};
			blk[$j]=$(( ${blk[$j]} ^ ((${blk[$j - 1]} + $t) % 2) ));
			pc=${blk[$j]};
		done;		

		for (( j=63; j>=0; j-- )); do	# undo transposition loop
			bi=$(( ${tk[$j]} + 1 ));
			t=${blk[$j + 1]};
			blk[$j + 1]=${blk[$bi]};
			blk[$bi]=$t;
		done;
	done;

	new_blk[0]=0;
	new_blk[1]=0;

	for (( i=0; i<32; i++ )); do	# rebuild data block
		new_blk[0]=$(( ${new_blk[0]} + (${blk[$i + 1]} << (31 - $i)) ));
		new_blk[1]=$(( ${new_blk[1]} + (${blk[$i + 33]} << (31 - $i)) ));
	done;

	printf "0x%08lX 0x%08lX\n" ${new_blk[0]} ${new_blk[1]};
}

function main
{
	typeset in_key;
	typeset in_blk;
	typeset out_blk;
	typeset new_blk;
	typeset ret;

	in_key[0]=0xAAAABBBB;
	in_key[1]=0xCCCCDDDD;
	in_key[2]=0xEEEEFFFF;
	in_key[3]=0x11112222;

	in_blk[0]=0x11111111;
	in_blk[1]=0x11111111;

	out_blk[0]=0;
	out_blk[1]=0;
	out_blk[2]=0;
	out_blk[3]=0;

	printf "%08lX%08lX%08lX%08lX = User key\n" ${in_key[0]} ${in_key[1]} \
		${in_key[2]} ${in_key[3]};
	
	printf "%08lX%08lX = Plaintext\n" ${in_blk[0]} ${in_blk[1]};

	set_key ${in_key[0]} ${in_key[1]} ${in_key[2]} ${in_key[3]};

	ret=`encrypt ${in_blk[0]} ${in_blk[1]}`;
	print $ret | read out_blk[0] out_blk[1];
	printf "%08lX%08lX = Ciphertext\n" ${out_blk[0]} ${out_blk[1]};

	ret=`decrypt ${out_blk[0]} ${out_blk[1]}`;
	print $ret | read new_blk[0] new_blk[1];
	printf "%08lX%08lX = Plaintext\n" ${new_blk[0]} ${new_blk[1]};
}

typeset key;

main;

