(*
 * MBC2 Pascal implementation.
 *
 * Algorithm developed by Michael W. Bombardieri <bombardierix@gmail.com>
 *
 * Version 0.0.1 (2006.11.24)
 *
 * The following code is released into the public domain by its author.
 *)


program mbc2;

var
	key : array[0..587] of byte;	(* should be global *)
	
procedure set_key(user_key : array of longword);
var
	blk : array[0..15] of byte;
	f : array[0..3] of byte;
	i : integer;
begin
   	for i := 0 to 587 do begin
		key[i] := i mod 256;
	end;
	
	f[0] := (user_key[0] and $ff000000) shr 24;
	f[1] := (user_key[1] and $ff000000) shr 24;
	f[2] := (user_key[2] and $ff000000) shr 24;
	f[3] := (user_key[3] and $ff000000) shr 24;
	
	blk[0] := f[0] xor f[1];
	blk[1] := f[0] xor f[2];
	blk[2] := f[0] xor f[3];
	blk[3] := f[1] xor f[2];
	blk[4] := f[1] xor f[3];
	blk[5] := f[2] xor f[3];
	blk[6] := f[0];
	blk[7] := f[1];
	blk[8] := f[2];
	blk[9] := f[3];

	f[0] := ((user_key[0] and $ff0000) shr 16);
	f[1] := ((user_key[1] and $ff0000) shr 16);
	f[2] := ((user_key[2] and $ff0000) shr 16);
	f[3] := ((user_key[3] and $ff0000) shr 16);

	blk[10] := blk[0] xor f[0];
	blk[11] := blk[1] xor f[1];
	blk[12] := blk[2] xor f[2];
	blk[13] := blk[3] xor f[3];
	blk[14] := f[0] xor f[1];
	blk[15] := f[2] xor f[3];

	for i := 0 to 587 do begin  (* primary key mix *)
		key[i] := key[i] xor ((blk[i mod 16] + f[i mod 4]) mod 256);
		f[i mod 4] := key[i];
	end;

	blk[0] := f[0] xor f[1];
	blk[1] := f[0] xor f[2];
	blk[2] := f[0] xor f[3];
	blk[3] := f[1] xor f[2];
	blk[4] := f[1] xor f[3];
	blk[5] := f[2] xor f[3];

	f[0] := ((user_key[0] and $ff00) shr 8);
	f[1] := ((user_key[1] and $ff00) shr 8);
	f[2] := ((user_key[2] and $ff00) shr 8);
	f[3] := ((user_key[3] and $ff00) shr 8);

	blk[6] := f[0] xor blk[2];
	blk[7] := f[1] xor blk[3];
	blk[8] := f[2] xor blk[4];
	blk[9] := f[3] xor blk[5];

	f[0] := user_key[0] and $ff;
	f[1] := user_key[1] and $ff;
	f[2] := user_key[2] and $ff;
	f[3] := user_key[3] and $ff;

	blk[10] := f[0] xor blk[6];
	blk[11] := f[1] xor blk[7];
	blk[12] := f[2] xor blk[8];
	blk[13] := f[3] xor blk[9];
	blk[14] := f[0] xor f[2];
	blk[15] := f[1] xor f[3];

	f[1] := f[1] xor f[0];
	f[2] := f[2] xor f[0];
	f[3] := f[3] xor f[0];

	for i := 0 to 587 do begin  (* secondary key mix *)
		key[i] := (key[i] + (blk[i mod 16] xor f[i mod 4])) mod 256;
		f[i mod 4] := key[i];
	end;
end;

procedure encrypt(var user_blk : array of longword);
var
	blk : array[0..63] of byte;
	sk : array[0..47] of byte;
	tk : array[0..63] of byte;
	i,j : integer;
	ki : integer;
	bi : integer;
	t : byte;
	pc : byte;
	kp : ^byte;
begin
	for i := 31 downto 0 do begin
		blk[31 - i] := (user_blk[0] and (1 shl i)) shr i;
		blk[63 - i] := (user_blk[1] and (1 shl i)) shr i;
	end;

	for i := 0 to 15 do begin	(* round loop *)
		ki := 36 * i;
		kp := @key[ki];
		for j := 0 to 47 do begin
			kp := @key[ki + j];
			tk[j] := kp^ shr 2;
			sk[j] := ((kp^) and $1) xor (((kp^) and $2) shr 1); 
		end;
		for j := 0 to 15 do begin
			tk[j + 48] := (tk[j] + tk[j + 1]) mod 64;
		end;

		for j := 0 to 63 do begin
			bi := tk[j];
			t := blk[j];
			blk[j] := blk[bi];
			blk[bi] := t;
		end;

		pc := 0;
		for j := 0 to 47 do begin
			t := sk[j];
			blk[j] := blk[j] xor ((pc + t) mod 2);
			pc := blk[j];
		end;

		for j := 48 to 63 do begin
			blk[j] := blk[j] xor blk[j - 36];
		end;
	end;

	user_blk[0] := 0;
	user_blk[1] := 0;
	for i := 0 to 31 do begin
		user_blk[0] := user_blk[0] + (blk[i] shl (31 - i));
		user_blk[1] := user_blk[1] + (blk[i+32] shl (31 - i));
	end;
end;

procedure decrypt(var user_blk : array of longword);
var
	blk : array[0..64] of byte;
	sk : array[0..47] of byte;
	tk : array[0..63] of byte;
	i,j : integer;
	ki : integer;
	bi : integer;
	t : byte;
	kp : ^byte;

begin
	for i := 31 downto 0 do begin
		blk[32 - i] := (user_blk[0] and (1 shl i)) shr i;
		blk[64 - i] := (user_blk[1] and (1 shl i)) shr i;
	end;

	for i := 15 downto 0 do begin	(* round loop *)
		ki := 36 * i;
		kp := @key[ki];
		for j := 0 to 47 do begin
			kp := @key[ki + j];
			tk[j] := kp^ shr 2;
			sk[j] := ((kp^) and $1) xor (((kp^) and $2) shr 1); 
		end;
		for j := 0 to 15 do begin
			tk[j + 48] := (tk[j] + tk[j + 1]) mod 64;
		end;

		for j := 64 downto 49 do begin
			blk[j] := blk[j] xor blk[j - 36];
		end;

		blk[0] := 0; (* you heard me! *)
		for j := 48 downto 1 do begin
			t := sk[j - 1];
			blk[j] := blk[j] xor ((t + blk[j - 1]) mod 2);
		end;

		for j := 63 downto 0 do begin
			bi := tk[j] + 1;
			t := blk[j + 1];
			blk[j + 1] := blk[bi];
			blk[bi] := t;
		end;

	end;

	user_blk[0] := 0;
	user_blk[1] := 0;
	for i := 0 to 31 do begin
		user_blk[0] := user_blk[0] + (blk[i+1] shl (31 - i));
		user_blk[1] := user_blk[1] + (blk[i+33] shl (31 - i));
	end;
end;

procedure example_usage;
var
	in_key : array[0..3] of longword;
	in_blk : array[0..1] of longword;
begin
	in_key[0] := $AAAABBBB;
	in_key[1] := $CCCCDDDD;
	in_key[2] := $EEEEFFFF;
	in_key[3] := $11112222;

	in_blk[0] := $11111111;
	in_blk[1] := $11111111;

	writeln(in_key[0], ',',  in_key[1], ',', in_key[2], ',', in_key[3], ' = User key');

	set_key(in_key);

	writeln(in_blk[0], ',',  in_blk[1], ' = Plaintext');

	encrypt(in_blk);

	writeln(in_blk[0], ',',  in_blk[1], ' = Ciphertext');

	decrypt(in_blk);

	writeln(in_blk[0], ',',  in_blk[1], ' = Plaintext');
end;


begin
	example_usage;
end. 
