/*
 *  SecuDE Release 4.3 (GMD)
 */
/********************************************************************
 * Copyright (C) 1994, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/********************************************************************
 *	EXPORT:							    *
 *								    *
 *		aux_alias()					    *
 *		aux_alias2Name()				    *
 *		aux_alias2DName()				    *
 *		aux_Name2alias()				    *
 *		aux_Name2NameOrAlias()				    *
 *		aux_DName2alias()				    *
 *		aux_DName2NameOrAlias()				    *
 *		aux_Name2aliasf()				    *
 *		aux_DName2aliasf()				    *
 *		aux_add_alias_name()				    *
 *		aux_add_alias()					    *
 *		aux_delete_alias()				    *
 *		aux_fprint_alias2dname()			    *
 *		aux_fprint_dname2alias()			    *
 *		aux_search_AliasList()				    *
 *		aux_next_AliasList()				    *
 *		aux_alias_nxtname()				    *
 *		aux_alias_chkfile()				    *
 *		aux_alias_getall()				    *
 *		aux_get_AliasList()				    *
 *		aux_put_AliasList()				    *
 *		aux_check_AliasList()				    *
 *		aux_select_AliasList()				    *
 *				  				    *
 *	LOCAL:							    *
 *								    *
 *		get_AliasList()					    *
 *		free_AliasList()				    *
 *		strmtch()					    *
 *                                                                  *
 *		aliaslist					    *
 *		last_aliaslist					    *
 *								    *
 ********************************************************************/


#include <stdio.h>
#include "af.h"
#ifdef MAC 
#include "Mac.h"
#endif




static AliasList * aliaslist;
static AliasList * last_aliaslist;
static Boolean     systemfile_write_protection;



#ifdef __STDC__
	static char	*strmtch	(char *a, char *b);
	static AliasList * get_AliasList();
	static void free_AliasList();
#else
	static char *strmtch();
	static AliasList * get_AliasList();
	static void free_AliasList();
#endif





/****************************************************************/

/*
 *	search alias
 *	return useralias/systemalias if found, else notstored
 *
 */

/***************************************************************
 *
 * Procedure aux_alias
 *
 ***************************************************************/
#ifdef __STDC__

AliasFile aux_alias(
	char	 *alias
)

#else

AliasFile aux_alias(
	alias
)
char	 *alias;

#endif

{
	char			*proc = "aux_alias";
	register AliasList	*aa;
	register Aliases 	*aliasmember;



	if (!alias) return(notstored);

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(notstored); 			 /* no alias names read */
		
	aa = aliaslist;
	while (aa)  {
		aliasmember = aa->a;
		while (aliasmember)  {
			if (!strcmp(aliasmember->aname, alias)) return(aliasmember->aliasfile);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}


	return(notstored);

}




/*
 *	search alias
 *	return pointer to owner's DName, else NULL
 */

/***************************************************************
 *
 * Procedure aux_alias2DName
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_alias2DName(
	Name	 *alias
)

#else

DName *aux_alias2DName(
	alias
)
Name	 *alias;

#endif

{
	DName   * dname;
	Name    * name;
	char	* proc = "aux_alias2DName";


	name = aux_alias2Name(alias);

	if(name) {
		dname = aux_Name2DName(name);
		free(name);
	}
	else dname = (DName *)0;

	return (dname);
}




/*
 *	search alias
 *	return pointer to owner's Name if target exists, else alias
 */

/***************************************************************
 *
 * Procedure aux_alias2Name
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_alias2Name(
	Name	 *alias
)

#else

Name *aux_alias2Name(
	alias
)
Name	 *alias;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char    *target, *zwalias, *zwalias2, *dd;
	DName   *zwdname;
	Boolean alias_in_Name_form = FALSE, free_dd = FALSE;
	char	*proc = "aux_alias2Name";


	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(aux_cpy_String(alias));  /* no alias names read */

	zwalias = (char *)0;
	if(strchr(alias, '=')) {

		/* if alias names are in the Name form, compare on the basis of
                   normalized names. Ignore ORName attributes.  */
 
		alias_in_Name_form = TRUE;
		zwdname = aux_ORName2DName(alias);
		if(zwdname) {
			zwalias = aux_DName2CAPITALName(zwdname);
			aux_free_DName(&zwdname);
		}
	}
	if(!zwalias) zwalias = aux_cpy_String(alias);


	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
			dd = aliasmember->aname;
			free_dd = FALSE;
			if(alias_in_Name_form && strchr(aliasmember->aname, '=')) {
				zwdname = aux_ORName2DName(aliasmember->aname);
				if(zwdname) {
					dd = aux_DName2CAPITALName(zwdname);
					free_dd = TRUE;
					aux_free_DName(&zwdname);
				}
				/*** else aux_free_error(); ***/
			}

			if (strcmp(dd, zwalias) == 0) {

				/* alias found, return target */
			
				free(zwalias);
				if(free_dd) free(dd);

				return(aux_cpy_String(aa->dname));
			}

			if(free_dd) free(dd);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	/* alias not found */

	free(zwalias);
	return(aux_cpy_String(alias));
}





/*
 *	search alias for DName with given flag for alias type
 *	return pointer to alias on success, else NULL
 */

/***************************************************************
 *
 * Procedure aux_DName2alias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2alias(
	DName		 *dname,
	AliasType	  type
)

#else

char *aux_DName2alias(
	dname,
	type
)
DName		 *dname;
AliasType	  type;

#endif

{
	char			*proc = "aux_DName2alias";
	Name 			*name;
	char 			*alias;



	if(!dname) return (CNULL);

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2alias(name, type);

	if (name) free(name);
	if (!alias) return(CNULL);


	return(alias);

}



/*
 *	search alias of type LOCALNAME for DName
 *	return pointer to alias on success, else Name form of DName
 *	(return CNULL if DName transformation failes)
 */

/***************************************************************
 *
 * Procedure aux_DName2NameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2NameOrAlias(
	DName		 *dname
)

#else

char *aux_DName2NameOrAlias(
	dname
)
DName		 *dname;

#endif

{
	char			*proc = "aux_DName2NameOrAlias";
	Name 			*name;
	char 			*alias;



	if(!dname) return (CNULL);

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2alias(name, LOCALNAME);

	if (!alias) return(name);
	else {
		free(name);
		return(alias);
	}
}


/*
 *	search alias of type LOCALNAME for Name
 *	return pointer to alias on success, else Name
 */

/***************************************************************
 *
 * Procedure aux_Name2NameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_Name2NameOrAlias(
	Name		 *name
)

#else

char *aux_Name2NameOrAlias(
	name
)
Name		 *name;

#endif

{
	char			*proc = "aux_Name2NameOrAlias";
	char 			*alias;



	if(!name) return (CNULL);

	alias = aux_Name2alias(name, LOCALNAME);

	if (!alias) return(aux_cpy_Name(name));
	else return(alias);
}




/*
 *	search alias for Name with given flag for alias type
 *	return pointer to alias on success, else NULL
 */

/***************************************************************
 *
 * Procedure aux_Name2alias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_Name2alias(
	Name		 *name,
	AliasType	  type
)

#else

char *aux_Name2alias(
	name,
	type
)
Name		 *name;
AliasType	  type;

#endif

{
	char	*proc = "aux_Name2alias";
	register Aliases 	*aliasmember, *am;
	register AliasList 	*aa;



	if(!name) return (CNULL);

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return (CNULL);  /* no alias names read */

	aa = aliaslist;
	while (aa) {
        	if (strcmp(aa->dname, name) == 0) {
	        	aliasmember = aa->a;
        		if(aliasmember) {
				if(type == ANYALIAS) {
					return(aux_cpy_String(aliasmember->aname)); /* return first alias entry */
				}
				while (aliasmember) {
					switch(type) {
						case RFCMAIL:
							if(strchr(aliasmember->aname, '@')) {
								return(aux_cpy_String(aliasmember->aname));
							}
							break; 
						case X400MAIL:
							if(strchr(aliasmember->aname, '=')) {
								return(aux_cpy_String(aliasmember->aname));
							}
							break; 
						case LOCALNAME:
							if(strchr(aliasmember->aname, '=')) break;
							if(strchr(aliasmember->aname, '@')) break;
							else {
								return(aux_cpy_String(aliasmember->aname));
							}
							break;
					}
					aliasmember = aliasmember->next;
				}
			}		
			else goto noalias;
		}
		aa = aa->next;
	}
noalias:
	return (CNULL);
}




/* 
 *	like aux_DName2alias(), but only for a given dname and alias file
 */

/***************************************************************
 *
 * Procedure aux_DName2aliasf
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2aliasf(
	DName		 *dname,
	AliasType	  type,
	AliasFile	  afile
)

#else

char *aux_DName2aliasf(
	dname,
	type,
	afile
)
DName		 *dname;
AliasType	  type;
AliasFile	  afile;

#endif

{
	char			*proc = "aux_DName2aliasf";
	Name 			*name;
	char 			*alias;



	if(!dname) return (CNULL);

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2aliasf(name, type, afile);

	if (name) free(name);
	
	if (!alias) return(CNULL);


	return(alias);

}




/* 
 *	like aux_Name2alias(), but only for a given name and alias file
 */

/***************************************************************
 *
 * Procedure aux_Name2aliasf
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_Name2aliasf(
	char		 *name,
	AliasType	  type,
	AliasFile	  afile
)

#else

char *aux_Name2aliasf(
	name,
	type,
	afile
)
char		 *name;
AliasType	  type;
AliasFile	  afile;

#endif

{
	char			*proc = "aux_Name2aliasf";
	register Aliases 	*aliasmember;
	register AliasList 	*aa;


	if(!name) return (CNULL);

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return (CNULL);  /* no alias names read */


	aa = aliaslist;
	while (aa) {
        	if (strcmp(aa->dname, name) == 0) {

			aliasmember = aa->a;
			if(aliasmember) {
		
				while (aliasmember) {
					if (aliasmember->aliasfile == afile) switch(type) {
		
						case ANYALIAS:		 /* next best: return first alias entry from aliasfile*/
		
							return(aux_cpy_String(aliasmember->aname));
							break;
		
						case RFCMAIL:
		
							if(strchr(aliasmember->aname, '@')) return(aux_cpy_String(aliasmember->aname));
							break; 
		
						case X400MAIL:
		
							if(strchr(aliasmember->aname, '=')) return(aux_cpy_String(aliasmember->aname));
							break; 
		
						case LOCALNAME:
		
							if(strchr(aliasmember->aname, '=')) break;
							if(strchr(aliasmember->aname, '@')) break;
							else return(aux_cpy_String(aliasmember->aname));
							break;
		
					}
					aliasmember = aliasmember->next;
				}
			}		
			else goto noalias;
		}
		aa = aa->next;
	}

noalias:
	return (CNULL);

}




/*
 *	add reduced alias to Name's entry with given flags for USER/SYSTEM-file, chaining priority, and immediate file writing
 *	aliases must be unique for each USER-/SYSTEM-file combination
 *	if prior is TRUE, alias is chained in as first entry (hi priority), else as last entry
 *	new DNames are inserted in alphabetical order
 *	return 0 on success, else -1
 */

/***************************************************************
 *
 * Procedure aux_add_alias_name
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_add_alias_name(
	char		 *alias,
	Name		 *name,
	AliasFile	  aliasf,
	Boolean		  prior,
	Boolean		  writef
)

#else

RC aux_add_alias_name(
	alias,
	name,
	aliasf,
	prior,
	writef
)
char		 *alias;
Name		 *name;
AliasFile	  aliasf;
Boolean		  prior;
Boolean		  writef;

#endif

{
        DName   *dn;
	char	*proc = "aux_add_alias_name";
	int	ret;



	dn = aux_Name2DName(name);
	ret = aux_add_alias(alias, dn, aliasf, prior, writef);
	aux_free_DName(&dn);
	return(ret);
}


/*
 *	like aux_add_alias_name(), for DNames
 */

/***************************************************************
 *
 * Procedure aux_add_alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_add_alias(
	char		 *alias,
	DName		 *dn,
	AliasFile	  aliasf,
	Boolean		  prior,
	Boolean		  writef
)

#else

RC aux_add_alias(
	alias,
	dn,
	aliasf,
	prior,
	writef
)
char		 *alias;
DName		 *dn;
AliasFile	  aliasf;
Boolean		  prior;
Boolean		  writef;

#endif

{
	register Aliases *aliasmember, *new_am;
	register AliasList *new_aa, *aa, *bb;
	Name    *n;
	char	*ralias;
	char	*proc = "aux_add_alias";



	if (! (ralias = aux_cpy_ReducedString(alias)) ) return(0);


	if (!aliaslist) aliaslist = get_AliasList();

	/*
         *  Try to find alias in aliaslist->aname. If found, return -1, else insert alias and return 0
	 *	prior: if TRUE, alias will be chained as first entry
	 *	       if FALSE, alias will be chained as last entry
         */

	if(!dn) return(-1);

	if (aux_alias(ralias) != notstored)  {		/* already there ? */
		if (ralias) free(ralias);
		return(-1);
	}

	n = aux_DName2Name(dn);

	aa = aliaslist;
	while (aa) {
		if(strcmp(aa->dname, n) == 0)  {		/* dname already exists with at least one alias */
			aliasmember = aa->a;
			while (aliasmember)  {
				if(!aliasmember->next)  { 		/* chain in new member */
					new_am = (Aliases *)malloc(sizeof(Aliases));
					if(!new_am) goto malloc_err;
					new_am->aname = (char *)malloc(strlen(ralias) + 1); 
					if(!new_am->aname) goto malloc_err;

					if (prior)  {			/* chain in as first alias */
						new_am->next = aa->a;
						aa->a = new_am;
					} else  {			/* chain in as last alias */
						aliasmember->next = new_am;
						new_am->next = (Aliases *)0;
					}
						
					strcpy(new_am->aname, ralias);
					new_am->aliasfile = aliasf;

					if (ralias) free(ralias);
					if (writef) {
						if(aux_put_AliasList(aliasf) < 0){
							aux_add_error(LASTERROR, "Can't put alias list after adding alias", CNULL, 0, proc);
							return(-1);
						}
					}

					return(0);
				}
				aliasmember = aliasmember->next;
			}
		}
		aa = aa->next;
	}


	/* else: new dname entry */

 	new_aa = (AliasList *)malloc(sizeof(AliasList));
 	if(!new_aa) goto malloc_err;
 	new_aa->a = (Aliases *)malloc(sizeof(Aliases)); 
 	if(!new_aa->a) goto malloc_err;
	aliasmember = new_aa->a;
  	aliasmember->aname = (char *)malloc(strlen(ralias) + 1); 
 	if(!aliasmember->aname) goto malloc_err;
  	strcpy(aliasmember->aname, ralias);
  	aliasmember->aliasfile = aliasf;
  	aliasmember->next = (Aliases *) 0;
 	new_aa->dname = (char *)malloc(strlen(n) + 1);
 	if(!new_aa->dname) goto malloc_err;
 	strcpy(new_aa->dname, n);

	aa = aliaslist;
	while (aa && strcmp(aa->dname, n) < 0)  {
		bb = aa; 
		aa = aa->next;
	}
	if(aa == aliaslist)  {
		new_aa->next = aliaslist;
		aliaslist = new_aa;
	} else  {
		new_aa->next = bb->next;
		bb->next = new_aa;
	} 
  
  	if (ralias) free(ralias);
  	if (writef){
		if(aux_put_AliasList(aliasf) < 0){
			aux_add_error(LASTERROR, "Can't put alias list after adding alias", CNULL, 0, proc);
			return(-1);
		}
	}
  
  	return(0);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	return(-1);


}



/*
 *	delete alias with given flags for USER/SYSTEM-file and immediate file writing
 *	return 0 on success, else -1
 */

/***************************************************************
 *
 * Procedure aux_delete_alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_delete_alias(
	char		 *alias,
	AliasFile	  aliasf,
	Boolean		  writef
)

#else

RC aux_delete_alias(
	alias,
	aliasf,
	writef
)
char		 *alias;
AliasFile	  aliasf;
Boolean		  writef;

#endif

{
	register Aliases *aliasmember, *aliasmemberpre;
	register AliasList *aa, *aapre;
	char	*proc = "aux_delete_alias";


	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	/*
         *  Try to find alias in aliaslist->aname fitting to given alias file. 
	 *  If found, chain out. Chain out dname entry, too, if last alias is deleted
         */

	aa = aliaslist;
	aapre = (AliasList * ) 0;
	while (aa)  {
		aliasmember = aa->a;
		aliasmemberpre = (Aliases * ) 0;
		while (aliasmember)  {

			if (!strcmp(aliasmember->aname, alias) && (aliasmember->aliasfile == aliasf))  {
  				if(aliasmemberpre) aliasmemberpre->next = aliasmember->next;
  				else if (aliasmember->next) aa->a = aliasmember->next;
  				else  {
 					if(aapre) aapre->next = aa->next;
 					else aliaslist = aa->next;
  
 					free(aa->dname);
 					free(aa);
  				}
  
  				free(aliasmember->aname);
				free(aliasmember);

				if (writef){
					if(aux_put_AliasList(aliasf) < 0){
						aux_add_error(LASTERROR, "Can't put alias list after deleting alias", CNULL, 0, proc);
						return(-1);
					}
				}

				return(0);

			}					
			aliasmemberpre = aliasmember;
			aliasmember = aliasmember->next;
		}
		aapre = aa;
		aa = aa->next;
	}


	return(-1);
}



/*
 *	search DName to which alias belongs and print to file
 *	if alias is NULL, print complete list to file
 *	return always 0
 */

/***************************************************************
 *
 * Procedure aux_fprint_alias2dnames
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_alias2dnames(
	FILE	 *ff,
	char	 *alias
)

#else

RC aux_fprint_alias2dnames(
	ff,
	alias
)
FILE	 *ff;
char	 *alias;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_alias2dnames";


	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	/*
         *  Try to find alias in aliaslist->aname. If found, return aliaslist->dname, else return alias
         */

	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
			if (!alias || strmtch(aliasmember->aname, alias)) {
                                fprintf(ff, "%s --> <%s>\n", aliasmember->aname, aa->dname);
                        }
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	return(0);
}

/***************************************************************
 *
 * Procedure aux_fprint_alias2dname
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_alias2dname(
	FILE	 *ff,
	char	 *alias
)

#else

RC aux_fprint_alias2dname(
	ff,
	alias
)
FILE	 *ff;
char	 *alias;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_alias2dname";


	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	/*
         *  Try to find alias in aliaslist->aname. If found, return aliaslist->dname, else return alias
         */

	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
			if (!alias || strcmp(aliasmember->aname, alias) == 0) {
                                fprintf(ff, "%s --> <%s>\n", aliasmember->aname, aa->dname);
				return(0);
                        }
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	return(0);
}



/*
 *	print all aliases which belong to DName to given file
 *	if DName is NULL, print complete list to file
 *	return always 0
 */

/***************************************************************
 *
 * Procedure aux_fprint_dname2alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_dname2alias(
	FILE	 *ff,
	char	 *dname
)

#else

RC aux_fprint_dname2alias(
	ff,
	dname
)
FILE	 *ff;
char	 *dname;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_dname2alias";


	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	/*
         *  Try to find alias in aliaslist->aname. If found, return aliaslist->dname, else return alias
         */

	aa = aliaslist;
	while (aa) {
        	if (!dname || strmtch(aa->dname, dname)) {
	        	aliasmember = aa->a;
        		while (aliasmember) {
                                fprintf(ff, "<%s> --> %s\n", aa->dname, aliasmember->aname);
        			aliasmember = aliasmember->next;
                        }
		}
		aa = aa->next;
	}

	return(0);
}



/*
 *	find pattern in any text element of all alias list entries beginning at entry after name
 *	if end of alias list is reached, continue at top until last found entry is reached
 *	comparisons are non-case-sensitive
 *	return pointer to name on success, else NULL
 *	NOTICE: uses aux_next_AliasList(), same name parameter behaviour
 */

/***************************************************************
 *
 * Procedure aux_search_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_search_AliasList(
	Name	 *name,
	char	 *pattern
)

#else

Name *aux_search_AliasList(
	name,
	pattern
)
Name	 *name;
char	 *pattern;

#endif

{
	char			*proc = "aux_search_AliasList";
	AliasList		*aa, *last_aa;
	register Aliases 	*aliasmember;
	register char		*s, *p, *last_name;



	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);

	if (! (p = aux_cpy_ReducedString(pattern)) ) return(CNULL);
	p = str_up(p);

	if (name) last_aa = last_aliaslist;	/* last found entry */
	else last_aa = (AliasList *)NULL;
	last_name = aux_next_AliasList(name);	/* entry after last found */
	if (!last_name) return(CNULL);

	do  {
		aa = last_aliaslist;
		if (! (s = aux_cpy_String(aa->dname)) ) return(CNULL);
		s = str_up(s);
		if (strstr(s, p))  {
			if (p) free(p);
			if (s) free(s);
			return(last_name);
		}
		if (s) free(s);
                aliasmember = aa->a;
                while (aliasmember)  {
			if (! (s = aux_cpy_String(aliasmember->aname)) ) return(CNULL);
			s = str_up(s);
			if (strstr(s, p))  {
				if (p) free(p);
				if (s) free(s);
				return(last_name);
			}
			if (s) free(s);
			aliasmember = aliasmember->next;
		}
		if (!name && !last_aa) last_aa = last_aliaslist;
		if (last_name) free(last_name);
		last_name = aux_next_AliasList("");

	} while (last_aa != last_aliaslist);

	if (p) free(p);
	if (last_name) free(last_name);

	return(CNULL);

}


/*
 *	return TRUE if DName has alias in given alias file, else FALSE
 */

/***************************************************************
 *
 * Procedure aux_alias_chkfile
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_alias_chkfile(
	Name		 *name,
	AliasFile	  aliasf
)

#else

Boolean aux_alias_chkfile(
	name,
	aliasf
)
Name		 *name;
AliasFile	  aliasf;

#endif

{
	char			*proc = "aux_alias_chkfile";
	register AliasList	*aa;
	register Aliases 	*aliasmember;



	if (!name) return(FALSE);
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(FALSE);

	aa = aliaslist;
	while (aa)  {
		if (!strcmp(aa->dname, name))  {
			aliasmember = aa->a;
			while (aliasmember) {
				if (aliasmember->aliasfile == aliasf) return(TRUE);		
				aliasmember = aliasmember->next;
			}
		}
		aa = aa->next;
	}
	return(FALSE);
}


/*
 *	get next name in AliasList after given name; if end of list is reached, return NULL
 *	if name is empty (""), get name after last found entry, begin with top entry at first time / if end of list is reached
 *	if name is NULL, reset and get name of top entry
 *	return pointer to allocated string on success, else NULL
 *	local pointer last_aliaslist is set
 *	NOTICE: called by aux_find_AliasList()
 */

/***************************************************************
 *
 * Procedure aux_next_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_next_AliasList(
	Name	 *name
)

#else

Name *aux_next_AliasList(
	name
)
Name	 *name;

#endif

{
	char			*proc = "aux_next_AliasList";



	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);
	if (name)  {
		if (strcmp(name, ""))  {				/* search for name */
			last_aliaslist = aliaslist;
			while (last_aliaslist)  {
				if (!strcmp(last_aliaslist->dname, name)) break;
				last_aliaslist = last_aliaslist->next;
			}
			if (!last_aliaslist) return(CNULL); 		/* name not found */
		}
		if (last_aliaslist) last_aliaslist = last_aliaslist->next;
	} else  last_aliaslist = (AliasList *)NULL;

	if (!last_aliaslist) last_aliaslist = aliaslist;

	return(aux_cpy_String(last_aliaslist->dname));
}



/*
 *	get name in AliasList after last found entry
 *	alias list is always passed through continual from top to end
 *	first entry's name is returned at first call, after end is reached, and when reset is TRUE
 *	if end of list is reached, return NULL, reset to top for next call
 *	independant of aux_find_AliasList() and aux_next_AliasList()
 */

/***************************************************************
 *
 * Procedure aux_alias_nxtname
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_alias_nxtname(
	Boolean	  reset
)

#else

Name *aux_alias_nxtname(
	reset
)
Boolean	  reset;

#endif

{
	char			*proc = "aux_alias_nxtname";
	
	static AliasList	*la = (AliasList *) 0;



	if (!aliaslist)  {
		aliaslist = get_AliasList();
		la = (AliasList *) 0;
	}
	if (!aliaslist) return(CNULL);
	if (!la || reset) la = aliaslist;
	else la = la->next;

	if (!la)  {
		la = (AliasList *) 0;
		return(CNULL);
	} else return(aux_cpy_String(la->dname));
}


/*
 *	get all aliases of name's entry
 *	return NULL-terminated string including all aliases separated by ':'
 */

/***************************************************************
 *
 * Procedure aux_alias_getall
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_alias_getall(
	char	 *name
)

#else

char *aux_alias_getall(
	name
)
char	 *name;

#endif

{
	char			*proc = "aux_alias_getall";
	AliasList		*aa;
	register Aliases	*aliasmember;
	char			*alias_string;
	


	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);

	aa = aliaslist;
	while (aa)  {
		if (!strcmp(aa->dname, name))  {
			if (! (alias_string = (char *)malloc(1)) ) goto malloc_err;
			*alias_string = '\0';
			aliasmember = aa->a;
			while (aliasmember)  {
				if (strcmp(alias_string, "")) strcat(alias_string, ":");
				if (! (alias_string = (char *)realloc(alias_string,
					strlen(alias_string) + strlen(aliasmember->aname) + 2)) ) goto malloc_err;
				strcat(alias_string, aliasmember->aname);
				aliasmember = aliasmember->next;
			}
			return(alias_string);
		}
		aa = aa->next;
	}

	return(CNULL);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	return(CNULL);

}



/*
 *	read alias files (via get_AliasList())
 *	return TRUE if OK, else FALSE
 */

/***************************************************************
 *
 * Procedure aux_get_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_get_AliasList(
)

#else

Boolean aux_get_AliasList(
)

#endif

{
	char	*proc = "aux_get_AliasList";



	af_pse_reset(AliasList_name);
	if (aliaslist) free_AliasList();
	aliaslist = get_AliasList();
	if (aliaslist) return(TRUE);
	else return(FALSE);

}





/*
 *	read alias list from USER- and SYSTEM-aliasfile
 *	DNames are sorted in alphabetical order, aliases are inserted from left-to-right in a FIFO-list
 *	USER-aliases are inserted prior to SYSTEM-aliases (affects transforming routines aux_this2that())
 *	reset last_aliaslist to NULL (used by aux_find_AliasList(), aux_alias_next())
 *	return pointer to first entry
 *	the static systemfile_write_protection is set to TRUE if .af-alias cannot be read
 */


/***************************************************************
 *
 * Procedure get_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

static AliasList *get_AliasList(
)

#else

static AliasList *get_AliasList(
)

#endif

{
	AliasList   		* alist = (AliasList *)0;
	AliasList		* alist_from_pse;
	register AliasList 	* aa, * aa_prev, * bb, * bb_prev;
	register Aliases	* aliasmember, * am;
	char	      		  afile[128];
	FILE        		* aff;
	int	      		  dir;
	OctetString 		* asn1_aliaslist;
	Boolean                   tmp_access_dir;
	VerificationResult      * tmp_verifresult;

	char	    		* proc = "get_AliasList";

	/*
         *  Read PSE-object AliasList and secude/.af-alias into alist
         */

	
	if (!af_use_alias) {
		systemfile_write_protection = TRUE;
		return((AliasList *)0);
	}
	systemfile_write_protection = FALSE;

	/* Read SYSTEM-aliasfile which is already sorted */

	strcpy(afile, ALIASDIR);
	if(afile[strlen(afile)-1] != PATH_SEPARATION_CHAR) strcat(afile, PATH_SEPARATION_STRING);
	strcat(afile, ALIASFILE);

	if ((aff = fopen(afile, "r"))) {

		if (accept_alias_without_verification == TRUE)
			asn1_aliaslist = aux_file2OctetString(afile);
		else {
			tmp_access_dir = af_access_directory;
			af_access_directory = FALSE;
			tmp_verifresult = verifresult;
			verifresult = (VerificationResult *)0;
			asn1_aliaslist = af_SignedFile2OctetString(afile);
			aux_free_VerificationResult(&verifresult);
			verifresult = tmp_verifresult;
			af_access_directory = tmp_access_dir;
		}

		if (! asn1_aliaslist) {
			aux_add_error(LASTERROR, "Can't get alias list", CNULL, 0, proc);
			fclose(aff);
			systemfile_write_protection = TRUE;
			goto read_user_alias;
		}

		aa = d_AliasList(asn1_aliaslist);
		aux_free_OctetString(&asn1_aliaslist);

		if (! aa)  {
			aux_add_error(EDECODE, "Can't decode Alias list", CNULL, 0, proc);
			return ((AliasList *)0);
		}

		alist = aa; 

		fclose(aff);
	}


	/* Read USER-aliasfile from PSE and sort it into SYSTEM-aliasfile */
read_user_alias:

	alist_from_pse = af_pse_get_AliasList();
	if (alist_from_pse) {
		if (! alist)
			alist = alist_from_pse;
		else  {
			/*
			 *	insert USER-aliases
			 *	(system- and user-entries are both sorted by DNames in add_alias() routines)
			 */
			aa = alist_from_pse;
			bb = alist;
			while (aa)  {
				while (bb && strcmp(aa->dname, bb->dname) > 0)  {	
					/* find insertion point */
					bb_prev = bb;
					bb = bb->next;
				}
				if (bb)  {
					if (strcmp(aa->dname, bb->dname) == 0)  {
						/* DName exists: chain in aliases on top,
						   free rest of double DName entry 	  */
						aliasmember = aa->a;
						while (aliasmember)  {
							am = aliasmember->next;
							aliasmember->next = bb->a;
							bb->a = aliasmember;
							aliasmember = am;
						}
						aa_prev = aa;
						aa = aa->next;
						free(aa_prev->dname);
						free(aa_prev);
					}
					else  {
						/* chain in new DName entry */
						aa_prev = aa;
						aa = aa->next;
						if (bb == alist)  {
							aa_prev->next = alist;
							alist = aa_prev;
							bb_prev = aa_prev;
						}
						else  {
							aa_prev->next = bb_prev->next;
							bb_prev->next = aa_prev;
							bb_prev = aa_prev;
						}
					}
				}
				else  {
					/* append all remaining entries, their DNames are "greater" */
					aa_prev = aa;
					aa = aa->next;
					aa_prev->next = bb_prev->next;
					bb_prev->next = aa_prev;
					bb_prev = aa_prev;
				}
			}
		}
	}
	/*** else aux_free_error(); ***/
			
	last_aliaslist = (AliasList *) 0;

	return(alist);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	last_aliaslist = (AliasList *) 0;
	systemfile_write_protection = TRUE;
	return ((AliasList *)0);
}




/*
 *	Write all fitting alias list entries to USER/SYSTEM-aliasfile.
 *	If there is no more alias in the useralias / systemalias file, 
 * 	the PSE-object AliasList / the three system alias files are deleted
 *	If systemfile_write_protection is TRUE (set by get_AliasList),
 *	or an error occured, -1 is returned.
 */

/***************************************************************
 *
 * Procedure aux_put_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_put_AliasList(
	AliasFile	  aliasf
)

#else

RC aux_put_AliasList(
	aliasf
)
AliasFile	  aliasf;

#endif

{
	OctetString 	   * asn1_aliaslist;
	char 	 	     afile[256], asigfile[256], actffile[256];
	AliasList	   * aa;
	PSESel		   * pse_sel;
	AlgId 		   * signAI;
	int		     rc;

	char		   * proc = "aux_put_AliasList";




	if ((aliasf == systemalias) && systemfile_write_protection) return(-1);


	strcpy(afile, ALIASDIR);
        if(afile[strlen(afile)-1] != PATH_SEPARATION_CHAR) strcat(afile, PATH_SEPARATION_STRING);
       	strcat(afile, ALIASFILE);
	strcpy(asigfile, afile);
	strcat(asigfile, EXT_SIGNATURE);
	strcpy(actffile, afile);
	strcat(actffile, EXT_CERTIFICATE);

	if (! aliaslist || !(aa = aux_select_AliasList(aliasf))) {
		if (aliasf == useralias) {
			if (pse_sel = af_pse_open(AliasList_OID, FALSE)) {
				rc = sec_delete(pse_sel);
				aux_free_PSESel(&pse_sel);
			}
			return(0);
		}
		if ((aliasf == systemalias)) {
			unlink(afile);
			unlink(asigfile);
			unlink(actffile);
			return(0);
		}
	}

	if (aliasf == useralias) {
		if (af_pse_update_AliasList(aa) < 0){
			aux_add_error(EWRITEPSE, "Can't put alias list", CNULL, 0, proc);
			return(- 1);
		}
		return(0);
	}

	asn1_aliaslist = e_AliasList(aa);
	if (! asn1_aliaslist) {
		aux_add_error(EENCODE, "Can't encode alias list", CNULL, 0, proc);
		return(- 1);
	} 

	rc = af_OctetString2SignedFile(afile, asn1_aliaslist, TRUE, NULLALGID);
	if (rc < 0) {
		aux_add_error(LASTERROR, "Can't put alias list", CNULL, 0, proc);
		return(- 1);
	}
		
	return(0);
}
	 


/*
 *	check alias list for consistency
 */

/***************************************************************
 *
 * Procedure aux_check_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_check_AliasList(
	FILE	 *ff
)

#else

Boolean aux_check_AliasList(
	ff
)
FILE	 *ff;

#endif

{
	char			*proc = "aux_check_AliasList";
	register Aliases	*aliasmember, *am;
	register AliasList 	*aa, *bb;
	Boolean			ret = TRUE;
	Boolean			found_first = FALSE;
	Boolean			found;


        
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(TRUE);
		
	aa = aliaslist;
	while (aa)  {
		aliasmember = aa->a;
		while (aliasmember)  {
			found = FALSE;
			bb = aliaslist;
			while (bb)  {
				am = bb->a;
				while (am)  {
					if ((am->aname != aliasmember->aname) && (!strcmp(am->aname, aliasmember->aname))) {
						if (!found_first)  {
							fprintf(ff, "aux_check_AliasList: There are double aliases.\n");
							fprintf(ff, "----------------------------------------------\n");
							fprintf(ff, " File  : <Alias>  =>  DName\n");
							fprintf(ff, "----------------------------------------------\n");
							found_first = TRUE;
						}
						fprintf(ff, "%s   <%s> = \"%s\"\n",
							aliasmember->aliasfile == useralias ? " USER " : "SYSTEM",
							aliasmember->aname, aa->dname);
						ret = FALSE;
						found = TRUE;
						break;
					}
					am = am->next;
				}
				if (found) break;

				bb = bb->next;
			}
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}


	return(ret);

}



/*
 *	check systemfile for write protection
 *	(set by get_AliasList)
 */

/***************************************************************
 *
 * Procedure aux_alias_writeprotection
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_alias_writeprotection(
)

#else

Boolean aux_alias_writeprotection(
)

#endif

{
	char			*proc = "aux_alias_writeprotection";


        
	if (!aliaslist) aliaslist = get_AliasList();

	return(systemfile_write_protection);

}



/***************************************************************
 *
 * Procedure aux_select_AliasList
 *
 ***************************************************************/

/* Select the appropriate alias entries (according to aliasf) from aliaslist */


#ifdef __STDC__

AliasList *aux_select_AliasList(
	AliasFile	  aliasf
)

#else

AliasList *aux_select_AliasList(
	aliasf
)
AliasFile aliasf;

#endif

{
	AliasList	 * aa, * bb, * cc;
	Aliases		 * aliasmember, * tmp_aliasmember;
	int		   first_a_flag, aa_equal_bb_flag;

	char	         *proc = "aux_select_AliasList";



	if(!aliaslist || (aliasf != useralias && aliasf != systemalias))
		return ((AliasList *)0);

	aa = bb = (AliasList * )malloc(sizeof(AliasList));
	if (! aa){
		aux_add_error(EMALLOC, "aa", CNULL, 0, proc);
		return ((AliasList *)0);
	}

	bb->dname = CNULL;
	bb->next = (AliasList * ) 0;
	bb->a = (Aliases * ) 0;

	cc = aliaslist;

	aa_equal_bb_flag = 1;

	while (cc) {
		aliasmember = cc->a;
		first_a_flag = 1;
		while (aliasmember) {
			if(aliasmember->aliasfile == aliasf) {
				if (first_a_flag) {
					if (! aa_equal_bb_flag) {
						bb->next = (AliasList * )malloc(sizeof(AliasList));
						bb = bb->next;
					}
					first_a_flag = aa_equal_bb_flag = 0;
					bb->a = tmp_aliasmember = (Aliases * )malloc(sizeof(Aliases));
					bb->dname = aux_cpy_Name(cc->dname);
					bb->next = (AliasList * ) 0;
				}
				else {
					tmp_aliasmember->next = (Aliases * )malloc(sizeof(Aliases));
					tmp_aliasmember = tmp_aliasmember->next;
				}
				tmp_aliasmember->aname = aux_cpy_Name(aliasmember->aname);
				tmp_aliasmember->aliasfile = aliasmember->aliasfile;
				tmp_aliasmember->next = (Aliases * ) 0;
			}
			aliasmember = aliasmember->next;
		}
		cc = cc->next;
	}

	if(!aa->dname){
		/* no entries of type 'aliasf' found */
		aux_free_AliasList(&aa);
		return((AliasList *)0);
	}

	return(aa);
}





/*
 *	free local alias list entries, set pointer to first entry to NULL
 */

/***************************************************************
 *
 * Procedure free_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

static void free_AliasList(
)

#else

static void free_AliasList(
)

#endif

{

	register Aliases *aliasmember, *am;
	register AliasList *aa, *bb;
	char	*proc = "free_AliasList";

        
        /*
         *  free alist
         */

        if(!aliaslist) return;
        aa = aliaslist;
        while (aa) {
                aliasmember = aa->a;
                while (aliasmember) {
                        free(aliasmember->aname);
                        am = aliasmember->next;
                        free(aliasmember);
                        aliasmember = am;
                }
                free(aa->dname);
                bb = aa->next;
                free(aa);
                aa = bb;
        }
	aliaslist = (AliasList *) 0;
}





/*
 *	search substring b in string a
 *	return pointer to character in a after first substring b found in a, else NULL
 */

/***************************************************************
 *
 * Procedure strmtch
 *
 ***************************************************************/
#ifdef __STDC__

static char *strmtch(
	char	 *a,
	char	 *b
)

#else

static char *strmtch(
	a,
	b
)
char	 *a;
char	 *b;

#endif

{
	char	*proc = "strmtch";
	register char *aa, *bb;



	while (*a) {
		aa = a;
		bb = b;
		while (*aa) {
			if(*aa != *bb) break;
                        bb++;
			if(*bb == '\0') return(aa + 1);
                        aa++;
		}
		a++;   
	}
	return (CNULL);
}








