/*
 *  SecuDE Release 4.3 (GMD)
 */
#ifdef MAC
#include <string.h>
#endif /* MAC */
#include "secure.h"

/***************************************************************
 *
 * Procedure catstr
 *
 ***************************************************************/
#ifdef __STDC__

int catstr(
	char	**ptr_str,
	int	 *ptr_len,
	char	 *new
)

#else

int catstr(
	ptr_str,
	ptr_len,
	new
)
char	**ptr_str;
int	 *ptr_len;
char	 *new;

#endif

{
	char	* mal;
	char	* proc = "catstr";

	if ( !new ) 
		return(0);
	*ptr_len += strlen( new );
	mal = malloc(*ptr_len);
	if (!mal) {
		aux_add_error(EMALLOC, "mal", CNULL, 0, proc);
		return(0);
	}
	new = strcat( strcpy(mal, *ptr_str), new );
	free( *ptr_str );
	*ptr_str = new;

	return(0);
}


/***************************************************************
 *
 * Procedure str_low
 *
 ***************************************************************/
#ifdef __STDC__

char *str_low(
	char	 *str
)

#else

char *str_low(
	str
)
char	 *str;

#endif

{
	char	*s;

	for ( s = str; *s; ++s ) 
		if ( *s >= 'A' && *s <= 'Z' ) 
			*s += 'a' - 'A';
	return( str );
}


/***************************************************************
 *
 * Procedure str_up
 *
 ***************************************************************/
#ifdef __STDC__

char *str_up(
	char	 *str
)

#else

char *str_up(
	str
)
char	 *str;

#endif

{
	char	*s;

	for ( s = str; *s; ++s ) 
		if ( *s >= 'a' && *s <= 'z' ) 
			*s -= 'a' - 'A';
	return( str );
}



/***************************************************************
 *
 * Procedure Trim
 *
 ***************************************************************/
#ifdef __STDC__

int Trim(
	char	 *str
)

#else

int Trim(
	str
)
char	 *str;

#endif

{
	char * 	s;

	s = &str[strlen(str)];
	while ( --s >= str && (*s == ' ' || *s == '\t') ) 
		*s = '\0';

	return(0);
}


/***************************************************************
 *
 * Procedure Skip_blanks
 *
 ***************************************************************/
#ifdef __STDC__

int Skip_blanks(
	char	 *str,
	int	 *ptr_idx
)

#else

int Skip_blanks(
	str,
	ptr_idx
)
char	 *str;
int	 *ptr_idx;

#endif

{
	char	c;

	while ( (c = str[*ptr_idx]) == ' ' || c == '\t' ) 
		++(*ptr_idx);
	return( c != '\0' );
}


/***************************************************************
 *
 * Procedure ScanOp
 *
 ***************************************************************/
#ifdef __STDC__

int ScanOp(
	char	 *str,
	int	 *ptr_idx,
	char	 *oper
)

#else

int ScanOp(
	str,
	ptr_idx,
	oper
)
char	 *str;
int	 *ptr_idx;
char	 *oper;

#endif

{
	char	c;

	while ( (c = str[*ptr_idx]) == ' ' || c == '\t' ) 
		++(*ptr_idx);
	if ( !strchr(oper, c)) 
		return( FALSE );
	++(*ptr_idx);
	return( TRUE );
}


/***************************************************************
 *
 * Procedure Scanv
 *
 ***************************************************************/
#ifdef __STDC__

char *Scanv(
	char	 *str,
	int	 *ptr_idx,
	char	 *delim
)

#else

char *Scanv(
	str,
	ptr_idx,
	delim
)
char	 *str;
int	 *ptr_idx;
char	 *delim;

#endif

{
	char	* token, c;
	int	  i, j;
	char	* proc = "Scanv";

	if ( !Skip_blanks(str, ptr_idx) ) 
		return( FALSE );
	for ( i = (*ptr_idx); 
	    (c = str[i]) != '\0' && c != '\n' && !strchr(delim, c); ++i)
		;
	if ( (i -= *ptr_idx) == 0 ) 
		return (CNULL);
	token = malloc( i + 1 );
	if (!token) {
		aux_add_error(EMALLOC, "token", CNULL, 0, proc);
		return (CNULL);
	}

	for ( j = 0; j < i; ++j ) 
		token[j] = str[(*ptr_idx)++];
	token[j] = '\0';
	return( token );
}


