/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "userlist.h"
#include "util.h"

static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd,bb));
}

static struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(inputfd));
}

static error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd,bb));
}

mosscrl_main (argc, argv)
int argc;
char **argv;
{
    int ret = NOTOK;
    struct cbstruct iocbs;
    char **localopts = NULLVP;
    char **avptr = NULLVP;
    char **user = NULLVP;
    char **issuer = NULLVP;
    struct user_list *revusers = NULLUL;
    struct user_list *tmpusers = NULLUL;
    int found;
    
    if (moss_init(argc, argv, &localopts) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
        goto cleanup;
    }

    /* check args, display help */

    if (argc > 1 && !strcasecmp(argv[1], "help")) {
        (void) fprintf(stderr, "%s %s\n\t%s\n\n", PACKAGE, VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s alias <alias> [...]", myname);
        return(1);
    }

    /* get issuer's user record */

    if ((avptr = tag_user(user_tailor, "sig-alias")) == NULLVP) {
	(void) fprintf(stderr, "%s: Unable to determine sig-alias.\n", myname);
	goto cleanup;
    }
    rewind_indexfile();
    if ((issuer = get_tv_user("alias", *(avptr+1))) == NULLVP) {
	(void) fprintf(stderr, 
		      "%s: Unable to find user with sig-alias alias \"%s\"\n", 
		      myname, *(avptr+1));
	goto cleanup;
    }
    
    /* get list of revoked users */

    if (localopts != NULLVP)
	for (avptr = localopts; *avptr != NULLCP; avptr +=2) {
	    if (strcasecmp(*avptr, "alias") != 0) {
		(void) fprintf(stderr,
			      "%s: Unknown tag/value pair \"%s %s\"\n",
			      myname, *avptr, *(avptr+1));
		goto cleanup;
	    }
	    found = 0;
	    rewind_indexfile();
	    while ((user = get_tv_user(*avptr, *(avptr+1))) != NULLVP) { 
		tmpusers = alloc_ul();
		tmpusers->user = user;
		user = NULLVP;
		tmpusers->next = revusers;
		revusers = tmpusers;
		tmpusers = NULLUL;
		found = 1;
	    }
	    if (!found) {
                (void) fprintf(stderr,
                              "%s: No users found with alias \"%s\"\n",
                              myname, *(avptr+1));
                goto cleanup;
	    }
	}

    /* set up cb for moss_crl */
    
    BZERO(&iocbs, sizeof(struct cbstruct));
    iocbs.in_user = user_in;
    iocbs.ne_user = user_ne;
    iocbs.out_user = user_out;
    iocbs.out_errs = error_out;

    /* call core routine */

    if ((ret=moss_crl(&issuer, revusers, &iocbs)) != OK) {
	(void) fprintf(stderr, "%s: Unable to process CRL.\n", myname);
	goto cleanup;
    }

    /* Save updated issuer record */

    if (update_indexfile(NULLVP, issuer) != OK) {
        (void) fprintf(stderr, "%s: Unable to update database.\n", myname);
        goto cleanup;
    }

    ret = OK;

 cleanup:

    FREE_AV(user);
    FREE_AV(issuer);
    FREE_UL(revusers);

    return ret;
}
