/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "dname.h"
#include "new.h"
#include "util.h"

static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static int user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd, bb));
}

static struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(inputfd));
}

static int error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd, bb));
}

mosskey_main(argc, argv)
int argc;
char **argv;
{
    char            **user = NULLVP,
                    **nuser = NULLVP,
                    **av = NULLVP,
                    *dnstr = NULLCP;
    struct cbstruct   iocbs;

    if (moss_init(argc, argv, &user) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", *argv);
	return(1);
    }

    if (argc < 5 || !strcmp(argv[1], "help")) {
        (void) fprintf(stderr, "%s %s\n%s\n\n", PACKAGE, VERSION, COPYRIGHT);
        (void) fprintf(stderr, 
		       "Usage: %s %s\nor\n       %s %s\n       %s\n",
		       myname,
		       "private-key-access <access> private-key <data>",
		       myname,
		       "private-key-access <access> private-key <data>",
		       "serial-number <hex> subject-name <dname>");
	return(1);
    }

    if (tag_user(user, "serial-number") != NULLVP)
	if (tag_user(user, "subject-name") == NULLVP) {
	    (void) fprintf(stderr,
			   "%s: missing subject-name for serial-number\n",
			   myname);
	    return(1);
	}


    /* Canonicalize subject name */

    if ((av = tag_user(user, "subject-name")) != NULLVP) {
        if ((dnstr = canon_str(*(av+1))) == NULLCP) {
            (void) fprintf(stderr, "%s: subject-name %s is invalid.\n",
                           myname, *(av+1));
	    return(1);
        }
        FREE(*(av+1));
        *(av+1) = dnstr;
        dnstr = NULLCP;
    }

    /* set up callbacks for moss_key */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.out_errs = error_out;
    iocbs.out_user = user_out;
    iocbs.in_user = user_in;
    iocbs.ne_user = user_ne;

    if ((nuser = moss_key(user, &iocbs)) == NULLVP) {
	(void) fprintf(stderr, "%s: Unable to create public/private keys.\n",
		       myname);
	return(1);
    }

    if (update_indexfile(NULLVP, nuser) != OK) {
	(void) fprintf(stderr, "%s: Unable to update database.\n", myname);
	return(1);
    }

    return(0);
}
