/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "userlist.h"
#include "util.h"

static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd,bb));
}

struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

struct bbuf *user_ne()
{
    return(cbfdneread(inputfd));
}

error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd,bb));
}

mosskeysign_main (argc, argv)
int argc;
char **argv;
{
    int ret = NOTOK;
    struct cbstruct iocbs;
    static char *appopt[] = {"serial-number", "NONE", NULLCP};
    struct user_list *signees = NULLUL;
    struct user_list *tmplist = NULLUL;
    char **localopts = NULLVP;
    char **serialopt = NULLVP;
    char **sigaliasopt = NULLVP;
    char **signee = NULLVP;
    char **signer = NULLVP;
    char **template = NULLVP;
    char *serial = NULLCP;
    char *pu = NULLCP;

    
    if (moss_init(argc, argv, &localopts) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
        goto cleanup;
    }

    /* check args, display help */

    if ((argc < 2) || (!strcasecmp(argv[1], "help"))) {
        (void) fprintf(stderr, "%s %s\n%s\n\n", PACKAGE, VERSION, COPYRIGHT);
        (void) fprintf(stderr, 
		       "Usage: %s alias <alias> [serial-number <hex>]\n", 
		       myname);
        return(1);
    }

    template = update_user (appopt, localopts);

    if ((serialopt = tag_user(appopt, "serial-number")) != NULLVP)
	if (strcmp(*(serialopt+1), "NONE") != 0)
	    serial = add2cp (NULLCP, *(serialopt+1));

    /* Get signer and [to-be-]signed user records */

    if ((sigaliasopt = tag_user(user_tailor, "sig-alias")) == NULLVP) {
 	(void) fprintf(stderr, "%s: missing sig-alias.\n", myname);
	goto cleanup; 
    } 

    rewind_indexfile(); 
    if ((signer = get_tv_user("alias", *(sigaliasopt+1))) == NULLVP) {
	(void) fprintf(stderr,
		       "%s: missing user for tag sig-alias value %s.\n",
		       myname, *(sigaliasopt+1));
	goto cleanup; 
    } 

    /* Set up cb */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.in_user = user_in;
    iocbs.out_user = user_out;
    iocbs.out_errs = error_out;
    iocbs.ne_user = user_ne;

    /* Read in list of users to be signed */
    
    rewind_indexfile(); 
    while ((signee = get_tvt_user(template)) != NULLVP) { 
	tmplist = alloc_ul();
	tmplist->user = signee;
	signee == NULLVP;
	tmplist->next = signees;
	signees = tmplist;
    }

    if (signees == NULLUL) {
	(void) fprintf(stderr,
	       "%s: Unable to find user to sign matching supplied template.\n",
		       myname); 
	goto cleanup; 
    }

    if (serial != NULLCP && signees->next != NULLUL) {
        (void) fprintf(stderr,
       "%s: Template must match a single user when signing a certificate.\n",
		       myname);
        goto cleanup;
    }

    /* Process each user record */

    pu = pretty_user(signer);
    (void) fprintf(stdout, "Signing with %s.\n", pu);
    FREE(pu);

    for (tmplist = signees; tmplist != NULLUL; tmplist = tmplist->next) {
        pu = pretty_user(tmplist->user);
	(void) fprintf(stdout, "\nSigning %s.\n", pu);
	FREE(pu);
	if ((ret = moss_keysign(signer, &(tmplist->user),
			       serial, &iocbs)) != OK) {
	    (void) fprintf(stderr, "%s: Unable to perform signature.\n", 
			   myname);
	    goto cleanup;
	}
	if ((ret = update_indexfile(NULLVP, tmplist->user)) != OK) {
	    (void) fprintf(stderr, "%s: Unable to update user record.\n", 
			   myname);
	    goto cleanup;
	}
    }

 cleanup:

    return(ret);
}
