/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "msg.h"
#include "new.h"
#include "userlist.h"
#include "util.h"

extern FILE *yyin;
extern struct msg *msg;

static int inputfd = 0; /* stdin by default */

static struct bbuf *data_in()
{
    return(cbfdread(inputfd));
}

static int error_out(bbuf)
struct bbuf *bbuf;
{
    (void) fprintf(stderr, "%s\n", bbuf -> data);
    (void) fflush(stderr);

    return(OK);
}

verify_main(argc, argv)
int argc;
char **argv;
{
    FILE             *hdrs = (FILE *)0;
    FILE             *data = (FILE *)0;
    struct cbstruct   iocbs;
    char            **origuser = NULLVP;
    char            **origpk = NULLVP;
    char            **localopts = NULLVP;
    char            **dataname = NULLVP;
    char            **headername = NULLVP;
    char            **me = NULLVP;
    char            **myalias;
    char             *pu;
    int               status = NOTOK;
    int              trusted;
    struct user_list *root = NULLUL,
                     *valid_path = NULLUL,
                     *ul;


    /*  initialize MOSS  */
    if (moss_init(argc, argv, &localopts) != OK) {
	fprintf(stderr, "%s: initialization failure\n", argv[0]);
	goto cleanup;
    }

    /*  process args */

    headername = tag_user(localopts, "header-in");
    dataname = tag_user(localopts, "data-in");

    if (headername == NULLVP || (argc == 2 && !strcasecmp(argv[1], "help"))) {
	(void) fprintf(stderr, "%s %s\n%s\n\n", PACKAGE, VERSION, COPYRIGHT);
	(void) fprintf(stderr, 
		       "Usage: %s header-in <filename> [data-in <filename>]\n",
		       myname);
	return(1);
    }

    if ((hdrs = fopen(*(headername+1), "r")) == (FILE *)0) {
	(void) fprintf(stderr, "%s: unable to read header-in file %s\n", 
		       myname, *(headername+1));
	goto cleanup;
    }

    if (dataname != NULLVP) 
        if ((data = fopen(*(dataname+1), "r")) != (FILE *)0) 
            inputfd = fileno(data);
        else {
            fprintf(stderr, "%s: unable to open data-in file %s\n",
                    myname, *(dataname+1));
            goto cleanup;
        }

    msg = alloc_msg();

    yyin = hdrs;
    if (yyparse()) {
	(void) fprintf(stderr,"%s: improperly formatted headers\n", myname);
	goto cleanup;
    }

    if (msg -> origusers == NULLUL) {
	(void) fprintf(stderr, "%s: missing Originator-ID: field\n", myname);
	goto cleanup;
    }
    
    /* Make sure we have enough info in the msg to verify it */
    /* Also save key/name pair if it's new */

    rewind_indexfile();
    if ((origuser = get_tvt_user(msg->origusers->user)) == NULLVP) {

        /* Nope, so see if we have the public key plus a new name form */
       
        if ((origpk = tag_user(msg->origusers->user,"public-key")) == NULLVP) {
	    /* No key anywhere */
	    (void)fprintf(stderr,
			  "%s: No public key found for originator.\n",myname);
	    goto cleanup;
	}
	
	rewind_indexfile();
	origuser = get_tv_user(*origpk, *(origpk+1));
	if (origuser == NULLVP || tag_user(origuser, "trusted") == NULLVP) {
	    msg->origusers->user = merge_user(msg->origusers->user,
					      origuser);
	    if (update_indexfile(NULLVP, msg->origusers->user) != OK) 
		(void)fprintf(stderr,
			      "%s: Unable to update database; continuing...\n",
			      myname);
	    FREE_AV(origuser);
	    origuser = msg->origusers->user;
	    msg->origusers->user = NULLVP;
	}
    }

    /* update user record in msg structure */

    FREE_AV(msg->origusers->user);
    msg->origusers->user = origuser;
    origuser = NULLVP;

    /* get my user records so I know where the root is */

    if ((myalias = tag_user(user_tailor, "my-alias")) == NULLVP) {
	fprintf(stderr, "%s: Missing my-alias.\n", *argv);
	goto cleanup;
    }

    rewind_indexfile();
    while ((me = get_tv_user("alias", *(myalias+1))) != NULLVP) {
	struct user_list *up;

	up = alloc_ul();
	up->user = me;
	up->next = root;
	root = up;
    }

    valid_path = validate_user(msg->origusers->user, root, &trusted);
    
    for (ul = valid_path; ul != NULLUL; ul = ul->next) {

	pu = pretty_user(ul->user);

	if (ul == valid_path) {
	    fprintf(stderr, "Originator %s is %s as follows:\n", pu, 
		    trusted ? "trusted" : "UNTRUSTED");
	    fprintf(stderr, "  The %s%c\n", 
		    pu, ul->next == NULLUL ? '.' : ',');
	}
	else
	    fprintf(stderr, "  which is trusted by %s%c\n", 
		    pu, ul->next == NULLUL ? '.' : ',');
	
	FREE(pu);
	
	if (ul->status == BUNKNOWN) 
	    fprintf(stderr, "    Status is unknown.\n");
	else {
	    if (ul->status & BSLFSGN)
		fprintf(stderr, "    Self signed.\n");
	    
	    if (ul->status & BNOVAL)
		fprintf(stderr, "    Validity period is not present.\n");
	    else if (ul->status & BBADVAL)
		fprintf(stderr, "    Certificate has expired.\n");
	    
	    if (ul->status & BNOSIG) 	 
		fprintf(stderr, "    Signature is not present.\n"); 	
	    else if (ul->status & BNOISS) 
		fprintf(stderr, "    Issuer record is not present.\n");
	    else if (ul->status & BBADSIG)
		fprintf(stderr, "    Signature is invalid.\n"); else ;
	    
	    if (ul->status & BNOCRL)
		fprintf(stderr, "    Issuer CRL is not present.\n");
	    else if (ul->status & BBADCRL)
		fprintf(stderr, "    Certificate has been revoked by issuer");
	    
	    if (ul->status & BNOSDN)
		fprintf(stderr, 
			"    Certificate subject name is not present.\n");
	    else if (ul->status & BNOIDN)
		fprintf(stderr, 
			"    Certificate issuer name is not present.\n");
	}
    }
    
    BZERO(&iocbs, sizeof(struct cbstruct));
    iocbs.in_data = data_in;	
    iocbs.out_errs = error_out;

    if (moss_verify(msg, &iocbs) != OK) {
	fprintf(stderr, "\nUnable to verify signature.\n");
	goto cleanup;
    }

    fprintf(stderr,
	    "\nSignature has been verified with %s public key.\n",
	    trusted ? "a trusted" : "an UNTRUSTED");

    status = OK;

 cleanup:

    if (hdrs != (FILE *)0)
	fclose(hdrs);
    if (data != (FILE *)0)
	fclose(data);

    FREE_AV(origuser);
    FREE_MSG(msg);

    return(status);
}
