#!/bin/sh
#
# The basic idea is that a version number consists of the following:
#
#	MAJOR.MINOR.SUBMINOR
#
# If nothing exists (or is unreadable) set the version number to 1.0.0, or
# any portion thereof.
#
# In the absence of other direction
#	increment SUBMINOR.
#
# If one additional argument is given
#	increment SUBMINOR by that amount (typically 1).
#
# If two additional arguments are given
#	increment MINOR by the first amount (typically 1)
#	reset SUBMINOR to the second amount (typically 0).
#
# If three additional arguments are given
#	increment MAJOR by the first amount (typically 1)
#	reset MINOR to the second amount (typically 0)
#	reset SUBMINOR to the third amount (typically 0).


if [ "x$1" = x ]; then
	echo 'Usage: $0 TOP-LEVEL-FILE [ [ [ MAJOR ] MINOR ] SUBMINOR ]' 1>&2
	exit 1
fi

if [ ! -r $1.major ]; then
    rm -f $1.major $1.minor $1.sminor
    echo 1 > $1.major
    echo 0 > $1.minor
    echo 0 > $1.sminor
elif [ ! -r $1.minor ]; then
    rm -f $1.minor $1.sminor
    echo 0 > $1.minor
    echo 0 > $1.sminor
elif [ ! -r $1.sminor ]; then
    rm -f $1.sminor
    echo 0 > $1.sminor
else

# All files exist and are readable.
# Increment all files according to arguments

    if [ "x$4" != "x" ]; then

	MAJOR=`cat $1.major`
	rm -f $1.major $1.minor $1.sminor

	echo $3 > $1.minor
	echo $4 > $1.sminor

	echo $MAJOR | \
	awk '   { major = $1 + "'$2'" }\
	    END { printf "%d\n", major > "'$1.major'" }'

    elif [ "x$3" != "x" ]; then

	MINOR=`cat $1.minor`
	rm -f $1.minor $1.sminor

	echo $3 > $1.sminor

	echo $MINOR | \
	awk '   { minor = $1 + "'$2'" }\
	    END { printf "%d\n", minor > "'$1.minor'" }'

    elif [ "x$2" != "x" ]; then

	SMINOR=`cat $1.sminor`
	rm -f $1.sminor

	echo $SMINOR | \
	awk '	{ sminor = $1 + "'$2'" }\
	    END { printf "%d\n", sminor > "'$1.sminor'" }'

    else

	SMINOR=`cat $1.sminor`
	rm -f $1.sminor

	echo $SMINOR | \
	awk '	{ sminor = $1 + 1 }\
	    END	{ printf "%d\n", sminor > "'$1.sminor'" }'

    fi
fi

rm -f $1.vrsn

echo '\begingroup' > $1.vrsn
echo '    \catcode`\#=12' >> $1.vrsn

MAJOR=`cat $1.major`
MINOR=`cat $1.minor`
SMINOR=`cat $1.sminor`

echo $MAJOR $MINOR $SMINOR | \
awk '	{ major = $1; minor = $2; sminor = $3 }\
END	{ printf "    \\gdef\\versiontag/{#%d.%d.%d}%%\n", \
	  major, minor, sminor >> "'$1.vrsn'" }'

echo '    \gdef\versiondate/{'`date`'}%' >> $1.vrsn
echo '\endgroup' >> $1.vrsn
echo '\typeout{Version \versiontag/ of \versiondate/}' >> $1.vrsn
