/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef _ASN1_
#define _ASN1_


/* IDENTIFIER OCTET = TAG CLASS | FORM OF ENCODING | TAG NUMBER */

/* TAG CLASSES */
#define CLASS_MASK 0xc0		/* bits 8 and 7 */
#define CLASS_UNIV 0x00		/* 0 = universal */
#define CLASS_APPL 0x40		/* 1 = application */
#define CLASS_CONT 0x80		/* 2 = context-specific */
#define CLASS_PRIV 0xc0		/* 3 = private */

/* FORM OF ENCODING */
#define FORM_MASK 0x20		/* bit 6 */
#define FORM_PRIM 0x00		/* 0 = primitive */
#define FORM_CONS 0x20		/* 1 = constructed */

/* TAG NUMBERS */
#define TAG_MASK  0x1f		/* bits 5 - 1 */
#define PRIM_INT  0x02		/* primitive INTEGER */
#define PRIM_BITS 0x03		/* primitive BIT STRING */
#define PRIM_OCTS 0x04		/* primitive OCTET STRING */
#define PRIM_NULL 0x05		/* primitive NULL */
#define PRIM_OID  0x06		/* primitive OBJECT IDENTIFIER */
#define CONS_SEQ  0x10		/* constructed SEQUENCE/SEQUENCE OF */
#define CONS_SET  0x11		/* constructed SET/SET OF */
#define DEFN_PRTS 0x13		/* defined PrintableString */
#define DEFN_T61S 0x14		/* defined T61String */
#define DEFN_UTCT 0x17		/* defined UTCTime */


/* LENGTH ENCODING */
#define LEN_XTND  0x80		/* indefinite or long form */
#define LEN_MASK  0x7f		/* bits 7 - 1 */


/* ASN.1 ERROR CODES */
#define ASN1_ERR01 (-2)		/* missing tag and length */
#define ASN1_ERR02 (-3)		/* unexpected tag/id */
#define ASN1_ERR03 (-4)		/* bad length for null type */
#define ASN1_ERR04 (-5)		/* missing length */
#define ASN1_ERR05 (-6)		/* indefinite length encoding not supported */
#define ASN1_ERR06 (-7)		/* extended length too long */
#define ASN1_ERR07 (-8)		/* length too long */
#define ASN1_ERR20 (-21)	/* error in prim2bits() */
#define ASN1_ERR21 (-22)	/* error in prim2int() */
#define ASN1_ERR22 (-23)	/* error in prim2oid() */
#define ASN1_ERR23 (-24)	/* error in int2prim() */
#define ASN1_ERR30 (-31)	/* unknown oid */


#include "bbuf.h"

/* Macro to determine the charset for encoded data */
#define CHARSET(x) \
	(((x) == NULLBB || (x)->data == NULLUCP) ? 0 : ((x)->data[0]&TAG_MASK))


/* BASIC DECLARATIONS */

extern struct bbuf *int2prim();
extern struct bbuf *bits2prim(), *prim2bits();


/* UTCTIME */

typedef struct UTCtime {
    int	    ut_year;
    int	    ut_mon;
    int	    ut_mday;
    int	    ut_hour;
    int	    ut_min;
    int	    ut_sec;
    int	    ut_usec;
    int	    ut_zone;
    int	    ut_flags;
#define	UT_NULL		0x00
#define	UT_ZONE		0x01
#define	UT_SEC		0x02
#define	UT_USEC		0x04
}			UTCtime, *UTC;
#define	NULLUTC	((UTC) 0)


void	   tm2ut();
char	  *time2str();
   
long	   gtime();
UTC	   str2utct();
struct tm *ut2tm();

#endif	/* _ASN1_ */
