/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef _CBIO_
#define _CBIO_

/* all input callbacks
 * 	take NO arguments
 * 	return a pointer to a bbuf or NULLBB
 *
 * all output callbacks
 * 	take a pointer to a bbuf as an argument
 * 	return OK or NOTOK as appropriate
 */

#define NULL_IOCBS (struct cbstruct *)0
#define NULL_INCB  (struct bbuf *(*)())0
#define NULL_OUTCB (int (*)())0
		    
struct cbstruct {
    struct bbuf * (*in_data)();	    /* input data */
    int           (*out_data)();    /* output data */
    struct bbuf * (*in_hdrs)();	    /* input headers */
    int           (*out_hdrs)();    /* output headers */
    struct bbuf * (*in_user)();	    /* input from user */
    struct bbuf * (*ne_user)();	    /* input from user that is NOT echoed */
    int           (*out_user)();    /* informational output to user */
    int           (*out_errs)();    /* error output to user */
};


extern struct bbuf *canoncb ();
extern struct bbuf *cbfdneread ();
extern struct bbuf *cbfdread ();
extern int          cbfdwrite ();
extern struct bbuf *cbfneread ();
extern struct bbuf *cbfread ();
extern int          cbfwrite ();
extern struct bbuf *cbmemread ();
extern int          cbmemwrite();

extern long         moss_logchk();

/* Options (32-bit mask) for encrypt, decrypt, sign, and verify callbacks */

#define ENCRYPT_NONE            0x00000000

#define DECRYPT_NONE            0x00000000
#define DECRYPT_SHOWKEY         0x00000001  /* Include decrypted DEK in hdr */
#define DECRYPT_SHOWRECIPS      0x00000002  /* List other recipients in hdr */

#define SIGN_NONE               0x00000000

#define VERIFY_NONE             0x00000000

#endif	/* not CBIO */
