#!/bin/sh

status=1
tmpfile1="/usr/tmp/encpt$$.1"
tmpfile2="/usr/tmp/encpt$$.2"

trap '/bin/rm -f $tmpfile1 $tmpfile2; exit $status' 0 1 2 3 9 15

umask 177

if [ $# -ne 0 ]; then 
   echo "$0 takes text on standard input and produces an encrypted MOSS" 1>&2
   echo "object on standard output." 1>&2
   echo " " 1>&2
   echo "Usage: $0 alias <alias> [...]" 1>&2
   echo " " 1>&2
   exit 
fi

echo 'Content-Type: text/plain; charset="us-ascii"'  > $tmpfile1
echo '' >> $tmpfile1
cat >> $tmpfile1

encobj.sh $tmpfile1 $tmpfile2 $*
status=$?

if [ $status -ne 0 ]; then
   echo "$0: Bad return from encobj.sh ($status)." 1>&2
elif [ ! -s $tmpfile2 ]; then
   echo "$0: encobj.sh did not produce an encrypted message." 1>&2
   status=1
fi

cat $tmpfile2

exit





