#!/bin/sh

status=1
tmpfile1="/usr/tmp/signobj1.$$"
tmpfile2="/usr/tmp/signobj2.$$"

trap '/bin/rm -f $tmpfile1 $tmpfile2; exit $status' 0 1 2 3 9 15

umask 177

boundary="--$$`date | tr '[a-zA-Z0-9 :]' '[0-909a-za-z]'`s--"

if [ $# -ne 2 ]; then 
   echo "$0 reads a MIME object from a file, signs it, and places the" 1>&2
   echo "resulting signed MOSS object in a file." 1>&2
   echo " " 1>&2
   echo "Usage: $0 <input object file> <output object file>" 1>&2
   echo " " 1>&2
   exit
fi

if [ ! -r $1 ]; then
   echo "$0: Unable to read input file $1." 1>&2
   exit
fi

echo 'Content-Type: multipart/signed; protocol="application/moss-signature";' \
	> $2
echo '        micalg="md5"; boundary="'$boundary'"' >> $2
echo '' >> $2
echo "--$boundary" >> $2

cat $1 >> $2

echo '' >> $2
echo "--$boundary" >> $2
echo "Content-Type: application/moss-signature" >> $2
echo "Content-Transfer-Encoding: quoted-printable" >> $2
echo '' >> $2

canon < $1 > $tmpfile1
sign data-in $tmpfile1 header-out $tmpfile2
status=$?

if [ $status -ne 0 ]; then
   echo "$0: sign returned a non-zero status ($status)." 1>&2
   /bin/rm -f $2
   exit 
elif [ ! -s "$tmpfile2" ]; then
   echo "$0: sign did not produce any useable output." 1>&2
   /bin/rm -f $2
   status=1
   exit 
fi

mossencode -qp < $tmpfile2 >> $2

echo '' >> $2
echo "--$boundary--" >> $2

exit


