#!/bin/sh

status=1
tmpfile="/usr/tmp/signtext$$"

trap '/bin/rm -f $tmpfile; exit $status' 0 1 2 3 9 15

umask 177

if [ $# -ne 2 ]; then 
   echo "$0 takes a file containing text as input and produces a file" 1>&2
   echo "containing a signed MOSS object as output." 1>&2
   echo " " 1>&2
   echo "Usage: $0 <text file> <signed file>" 1>&2
   echo " " 1>&2
   exit 
fi

if [ ! -r $1 ]; then
   echo "$0: Unable to read input file $1." 1>&2
   exit 
fi

if [ ! -w $2 ]; then
   touch $2 2>&1 > /dev/null
   if [ ! -w $2 ]; then
      echo "$0: Unable to write output file $2." 1>&2
      exit 
   fi 
fi

echo 'Content-Type: text/plain; charset="us-ascii"'  > $tmpfile
echo '' >> $tmpfile
cat $1 >> $tmpfile

signobj.sh $tmpfile $2
status=$?

if [ $status -ne 0 ]; then
   echo "$0: Bad return from signobj.sh ($status)." 1>&2
elif [ ! -s $2 ]; then
   echo "$0: signobj.sh did not produce a signed message." 1>&2
   status=1
fi

exit





