/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_null(enull, rlength)
struct bbuf *enull;
int *rlength;
{
    int length;
	
    if (enull == (struct bbuf *)0 || rlength == (int *)0) 
	return(NOTOK);

    if (enull->length < 2) 
	return(ASN1_ERR01);

    if (enull->data[0] != (CLASS_UNIV|FORM_PRIM|PRIM_NULL)) 
	return(ASN1_ERR02);

    if ((length = enull->data[1]) != 0x00) 
	return(ASN1_ERR03);

    *rlength = length + 2;

    return(OK);
}
