/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_str(estr, eid, dstr, rlength)
struct bbuf *estr;
int eid;
struct bbuf **dstr;
int *rlength;
{
	int id;
	int llen;
	int length;
	int r;
	
	if (estr == NULLBB || dstr == (struct bbuf **)0 || rlength == (int *)0)
	    return(NOTOK);

	FREE_BBUF(*dstr);

	if (estr->length < 2) 
	    return(ASN1_ERR01);

	if ((id = estr->data[0]) == (CLASS_UNIV|FORM_PRIM|PRIM_NULL))
	    return(decode_null(estr, rlength));

	if (id != eid) 
	    return(ASN1_ERR02);

	r = decode_len(&(estr->data[1]), estr->length-1, &length, &llen);
	if (r != OK) return(r);
	*rlength = 1 + llen + length;

	*dstr = alloc_bbuf();
	(*dstr)->length = length;
	(*dstr)->data = alloc_uchar(length);

	if (length)
	    BCOPY(&estr->data[1+llen], (*dstr)->data, length);

	return(OK);
}
