/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

encode_str(dstr, id, estr)
struct bbuf *dstr;
int id;
struct bbuf **estr;
{
	struct bbuf *lenbb = NULLBB;

	if (estr == (struct bbuf **)0) 
	    return(NOTOK);

	if (*estr != NULLBB) {
	    (void) free_bbuf(*estr);
	    *estr = NULLBB;
	}

	if (dstr == NULLBB || !dstr->length)
	    return(encode_null(CLASS_UNIV|FORM_PRIM|PRIM_NULL, estr));

	if (encode_len(dstr->length, &lenbb) != OK)
	    return(NOTOK);

	*estr = alloc_bbuf();
	(*estr)->data = alloc_uchar(1+lenbb->length+dstr->length);
	(*estr)->length = 1 + lenbb->length + dstr->length;

	(*estr)->data[0] = id;
	BCOPY(lenbb->data, &((*estr)->data[1]), lenbb->length);
	BCOPY(dstr->data, &((*estr)->data[1+lenbb->length]), dstr->length);

	(void) free_bbuf(lenbb);

	return(OK);
}
