/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"

#include <stdio.h>

#include "general.h"

#include "allocate.h"
#include "bbuf.h"
#include "oid.h"
#include "util.h"

OID prim2oid(bb)
struct bbuf *bb;
{
    unsigned long i;
    unsigned long *ip;
    unsigned char *dp, *ep;
    OID o = NULLOID;

    dp = bb->data;
    ep = dp + bb->length;

    for (i = 1; dp < ep; i++) {	/* another whacko ISO encoding... */
	if (*dp == 0x80)
	    return(o);

	while (*dp++ & 0x80)
	    if (dp > ep)
		return(o);
    }

    allocate(&o, struct OIDentifier, sizeof(*o));
    allocate(&ip, unsigned long, (unsigned)(i + 1) * sizeof(*ip));

    o -> oid_elements = ip, o -> oid_nelem = i;
    
    for (dp = bb->data; dp < ep; ) {
	i = 0;
	do {
	    i <<= 7; 
	    i |= *dp & 0x7f;
	} while (*dp++ & 0x80);
	if (ip == o -> oid_elements)
	    *ip++ = i / 40, *ip++ = i % 40;
	else
	    *ip++ = i;
    }

    return o;
}
