/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <ctype.h>
#include <stdio.h>
#include "general.h"
#include "asn1.h"

#define	YEAR(y)		((y) >= 100 ? (y) : (y) + 1900)

long	get_usec ();

UTC	str2utct (cp, len)
char  *cp;
int	len;
{
    int     year, hours, mins;
    int    zone;
    static UTCtime  ut;
    UTC    u = &ut;

    if (len < 10)
	return NULLUTC;

    BZERO(u, sizeof *u);
	
    year = cp2i(cp, 2, 10);
    u->ut_mon = cp2i (cp + 2, 2, 10);
    u->ut_mday = cp2i (cp+4, 2, 10);
    u->ut_hour = cp2i (cp+6, 2, 10);
    u->ut_min = cp2i (cp+8, 2, 10);

    cp += 10, len -= 10;
    u -> ut_year = YEAR (year);

    if (len > 0 && isdigit (*cp)) {
	u->ut_sec = cp2i(cp, 2, 10);
	u -> ut_flags |= UT_SEC;
	cp += 2, len -= 2;
    }

    if (len > 0) {
	switch (*cp) {
	    case 'Z': 
		cp++, len--;
		break;

	    case '+': 
	    case '-': 
		hours = cp2i(cp + 1, 2, 10);
		mins = cp2i(cp + 3, 2, 10);
		zone = hours * 60 + mins;
		u -> ut_zone = *cp == '+' ? zone : -zone;
		cp += 5, len -= 5;
		break;

	    default: 
		return NULLUTC;
	}
	u -> ut_flags |= UT_ZONE;
    }
    if (len != 0)
	return NULLUTC;

    return u;
}
