/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"

/* set fd's echo mode (true/false) and return previous setting or -1 if
 * fd doesn't point to a terminal
 */

#ifndef PC

#include <sgtty.h>

int ttyecho(fd, echo)
int fd;
int echo;
{
    struct sgttyb ttyparams;
    int was_echo;

    if (!isatty (fd))
	was_echo = -1;
    else {
	ioctl(fd, TIOCGETP, &ttyparams);
	was_echo = (ttyparams.sg_flags & ECHO) != 0;
	if (echo)
	    ttyparams.sg_flags = ttyparams.sg_flags | ECHO;
	else
	    ttyparams.sg_flags = ttyparams.sg_flags & ~ECHO;
	ioctl(fd, TIOCSETP, &ttyparams);
    }

    return was_echo;
}

#else
int ttyecho(fd, echo)
int fd;
int echo;
{
    static int xx;
    int was_echo;

    was_echo = xx;
    xx = echo;
    if( !isatty(fd))
	was_echo = -1;
    return was_echo;
}

#endif
