/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <stdio.h>
#include <time.h>
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

#define R_ISSUER_DN	"issuer distinguished name: "
#define R_RCL		"revoked certificate list: "
#define R_RCL_ENTRY	"    revoked certificate: "
#define R_SERIAL_NBR	"        serial number: "
#define R_DATE		"        revocation date: "
#define R_LAST		"last update: "
#define R_NEXT		"next update: "
#define R_ALG		"signature algorithm: "
#define R_SIGNATURE	"signature: "
#define R_STATUS	"status: "

disp_crl (crl, out)
struct bbuf	*crl;
char		***out;
{
    char		**av= NULLVP, **tav;
    char		*cp = NULLCP, *cp2, *c;
    unsigned char	*buf = NULLUCP;
    struct rcl_entry	*rcl= NULL_RCL_ENTRY, *ptr;
    struct bbuf		*issuer = NULLBB;
    int			length, retval= NOTOK;
    struct algid	*aid = NULL_ALGID;
    long		last, next;

    if (out == (char ***)0)
	return(NOTOK);

    /* check to see that we got a pointer to a crl */
    if (crl == NULLBB || !crl->length) {
	*out = add2av(*out, add2cp(NULLCP, "NULL CRL"));
	return(NOTOK);
    }

    /* status field */
    *out = add2av(*out, add2cp(NULLCP, R_STATUS));
    if (disp_crl_status((unsigned short)crl->status, &av) == OK) {
	if (av == NULLVP) {
	    cp = add2cp(NULLCP, "    UNKNOWN");
	    *out = add2av(*out, cp);
	}
	else
	    for (tav = av; *tav != NULLCP; tav++) {
		cp = add2cp(NULLCP, "    ");
		cp = add2cp(cp, *tav);
		*out = add2av(*out, cp);
	    }
        FREE_AV(av);
        cp = NULLCP;
    }

    /* inner sig_alg identifier field */
    *out = add2av(*out, add2cp(NULLCP, R_ALG));
    if ((sig_alg_crl(&crl, &aid, INNER, READ)) == OK) {
	tav = NULLVP;
	(void) disp_algid(aid, &tav);
	prefixav(tav, "    ");
	*out = addav2av(*out, tav);
	FREE_AV(tav);
    }

    /* issuer field */
    cp = add2cp(cp, R_ISSUER_DN);
    *out = add2av(*out, cp);
    cp = NULLCP;
    if ((issuer_crl(&crl, &issuer, READ) == OK) && (issuer != NULLBB))  {
        (void) disp_dn(issuer, &tav);
	prefixav(tav, "    ");
        *out = addav2av(*out, tav);
        FREE_AV(tav);
    }

    /* last next update field */
    if((valid_crl(&crl, &last, &next, READ)) != OK) 
	goto cleanup;
    cp = add2cp(cp, R_LAST);
    cp2 = ctime(&last);
    if ((c=RINDEX(cp2, '\n')) != NULLCP)
        *c = NULLC;
    cp = add2cp(cp, cp2);
    *out = add2av(*out, cp);
    cp = NULLCP;

    cp = add2cp(cp, R_NEXT);
    cp2 = ctime(&next);
    if ((c=RINDEX(cp2, '\n')) != NULLCP)
        *c = NULLC;
    cp = add2cp(cp, cp2);
    *out = add2av(*out, cp);
    cp = NULLCP;

    /* rcl fields */
    cp = add2cp(cp, R_RCL);
    *out = add2av(*out, cp);
    cp = NULLCP;
    if((rcl_crl(&crl, &rcl, READ)) != OK) 
	goto cleanup;
    if (rcl == NULL_RCL_ENTRY)
	*out = add2av(*out, add2cp(NULLCP, "    NULL LIST"));
    for (ptr = rcl; ptr != NULL_RCL_ENTRY; ptr = ptr->next) {
	cp = add2cp(cp, R_RCL_ENTRY);
        *out = add2av(*out, cp);
	cp = NULLCP;

	cp = add2cp(cp, R_SERIAL_NBR);
	cp = add2cp(cp, "0x");
	cp = addhex2cp(cp, ptr->serial->data, ptr->serial->length);
        *out = add2av(*out, cp);
	cp = NULLCP;

	cp = add2cp(cp, R_DATE);
	cp2 = ctime(&(ptr->date));
	if ((c=RINDEX(cp2, '\n')) != NULLCP)
	    *c = NULLC;
        cp = add2cp(cp, cp2);
        *out = add2av(*out, cp);
	cp = NULLCP;
    }

    /* outer sig_alg identifier field */
    *out = add2av(*out, add2cp(NULLCP, R_ALG));
    if ((sig_alg_crl(&crl, &aid, OUTER, READ)) == OK) {
	(void) disp_algid(aid, &tav);
	prefixav(tav, "    ");
        *out = addav2av(*out, tav);
        FREE_AV(tav);
    }

    /* signature field */
    cp = add2cp(cp, R_SIGNATURE);
    if ((sig_crl(&crl, &buf, &length, READ)) != OK)
        *out = add2av(*out, add2cp(NULLCP, "           NOT SIGNED"));
    else 
        *out = add2av(*out, addhex2cp(cp, buf, length));

    retval = OK;

 cleanup:

    FREE(cp);
    FREE_UCHAR(buf);
    FREE_BBUF(issuer);
    FREE_RCL(rcl);
    FREE_ALGID(aid);

    return(retval);
}


int disp_crl_status(status, out)
unsigned short status;
char ***out;
{
    if (out == (char ***)0)
	return(NOTOK);

    if (status == 0) {
	*out = add2av(*out, add2cp(NULLCP, "crl is valid"));
	return(OK);
    }

    if (status == BUNKNOWN) {
	*out = add2av(*out, add2cp(NULLCP, "crl status is unknown"));
	return(OK);
    }

    if (status & BBADCHN)
	*out = add2av(*out, add2cp(NULLCP, "issuer certificate is invalid"));

    if (status & BNOVAL)
	*out = add2av(*out, add2cp(NULLCP,"crl update period is not present"));
    else if (status & BBADVAL)
	*out = add2av(*out, add2cp(NULLCP, "crl has expired"));
    else ;

    if (status & BNOSIG)
	*out = add2av(*out, add2cp(NULLCP, "crl signature is not present"));
    else if (status & BNOISS)
	*out = add2av(*out, add2cp(NULLCP, 
				   "issuer certificate is not present"));
    else if (status & BBADSIG)
	*out = add2av(*out, add2cp(NULLCP, "crl signature is invalid"));
    else ;

    if (status & BNOIDN)
	*out = add2av(*out, add2cp(NULLCP, "crl issuer name is not present"));

    return(OK);
}

