/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * parms_algid.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "util.h"

parms_algid(aid, parms, mode)
struct algid *aid;
struct bbuf **parms;
int mode;
{
    /* DOUBLE-CHECK PARAMETERS */
    if (aid == NULL_ALGID || parms == (struct bbuf **)0) 
	return(NOTOK);

    switch (mode) {
    case READ:
	if (aid->parms == NULLBB) 
	    return(NOTOK);

        FREE_BBUF(*parms);

	if ((*parms = dup_bbuf(aid->parms)) == NULLBB)
	    return(NOTOK);

	break;

    case WRITE:
	FREE_BBUF(aid->parms);

	if (*parms == NULLBB) 
	    return(NOTOK);

	if ((aid->parms = dup_bbuf(*parms)) == NULLBB)
	    return(NOTOK);

	break;

    default:
	return(NOTOK);
    }

    return(OK);
}


