/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 *  cbencipher_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "util.h"

#include "./global.h"
#include "./des.h"

/****************************************************************************/

static int cbencipher_descbc(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    struct bbuf *key = NULLBB;	/* key */
    struct bbuf *iv = NULLBB;	/* IV */
    int blklen;			/* input buffer length */
    unsigned char indata[8];    /* input block */
    unsigned char outdata[8];   /* output block */
    struct bbuf outbuf;
    int i;
    int padlen;
    DES_CBC_CTX context;

    /* decode key & iv */

    if (decode_deskeydata(curdata, &key) != OK)
        return(NOTOK);
    if (decode_deskeyparms(curparms, &iv) != OK)
	return(NOTOK);

    /* set up key schedule */

    DES_CBCInit(&context, key->data, iv->data, 1 /* encrypt */);
    FREE_BBUF(key);
    FREE_BBUF(iv);

    /* housekeeping */

    outbuf.data = outdata;
    outbuf.length = 8;

    /* encrypt all but final, padded block */

    while ((blklen = readblock(incb, 8, indata)) == 8) {
	DES_CBCUpdate(&context, outdata, indata, 8);
        (void) outcb(&outbuf);
    }

    padlen = 8 - blklen;
    for (i = blklen; i < 8; i++) 
	indata[i] = (unsigned char)padlen;
    DES_CBCUpdate(&context, outdata, indata, 8);
    (void) outcb (&outbuf);

    return(OK);
}

/****************************************************************************/

int cbencipher_des(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    int r;

    /* double-check parameters */

    if (incb == NULL_INCB || outcb == NULL_OUTCB)
	goto cleanup;

    /* encrypt with specified mode of operation */

    switch(curalg) {
    case DES_CBC:
	if ((r = cbencipher_descbc(incb, outcb)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

 cleanup:

    return(r);
}    


