/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 *  deciph_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./global.h"
#include "./des.h"

/*****************************************************************************/

static int decipher_descbc();

int decipher_des(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int r;

    /* double-check parameters */

    if (in == NULLBB || out == (struct bbuf **)0) 
	return(NOTOK);

    /* decrypt with specified mode of operation */

    switch(curalg) {
    case DES_CBC:
	if ((r = decipher_descbc(in, out)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

cleanup:

    return(r);
}

/****************************************************************************/

static int decipher_descbc(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int i;			/* in buffer index */
    struct bbuf *key = NULLBB;          /* Key */
    struct bbuf *iv = NULLBB;		/* IV */
    int padlen;
    int inlen, outlen;
    unsigned char *indata, *outdata;
    DES_CBC_CTX context;

    if (in->length == 0 || (in->length % 8) != 0) 
	return(NOTOK);

    inlen = in->length;
    indata = in->data;

    /* allocate plaintext output buffer */

    *out = alloc_bbuf();
    (*out)->length = in->length;
    (*out) -> data = alloc_uchar((*out) -> length);
    outlen = (*out)->length;
    outdata = (*out)->data;

    /* decode des key & iv */

    if (decode_deskeydata(curdata, &key) != OK) {
	FREE_BBUF(*out);
        return(NOTOK);
    }
    if (decode_deskeyparms(curparms, &iv) != OK) {
	FREE_BBUF(*out);
	return(NOTOK);
    }

    /* set up key schedule */

    DES_CBCInit(&context, key->data, iv->data, 0 /* decrypt */);
    FREE_BBUF(key);
    FREE_BBUF(iv);

    for (i = 0; i < inlen; i += 8) 
	DES_CBCUpdate(&context, outdata+i, indata+i, 8);

    padlen = outdata[inlen-1];
    if (padlen < 1 || padlen > 8) {
	FREE_BBUF(*out);
	return(NOTOK);
    }
    (*out)->length = outlen-padlen;

    return(OK);
}


