/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * adddekparms2cp.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int adddekparms2cp(edek, cpp)
struct bbuf *edek;
char **cpp;
{
    struct ccbent *ce = NULL_CCBENT;
    struct key *dek= NULL_KEY;
    int ret= NOTOK, alg;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (edek == NULLBB || cpp == (char **)0) 
	goto cleanup;

    if (decode_key(edek, &dek) != OK) 
	goto cleanup;

    if (dek->algid == NULL_ALGID) 
	goto cleanup;

    alg = dek->algid->alg;

    /* GET ALGORITHM TABLE ENTRY */
    if ((ce = getccbcode(callbacks, alg)) == NULL_CCBENT) 
	goto cleanup;

    /* CONVERT THE KEY PARMS TO A STRING */
    ret = (ce->addXparms2cp == NULL_FUNC) ? OK
	: (*(ce->addXparms2cp))(dek, cpp);

 cleanup:

    FREE_KEY(dek);
    return(ret);
}


