/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int gen_key(alg, len, ekey1, ekey2)
int alg;
int len;
struct bbuf **ekey1;
struct bbuf **ekey2;
{
    int r;
    struct algent *ae = NULL_ALGENT;
    struct ccbent *ce = NULL_CCBENT;
    struct key	  *key1= NULL_KEY, *key2= NULL_KEY;

    if (ekey1 == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*ekey1);
    if (ekey2 != (struct bbuf **)0) 
	FREE_BBUF(*ekey2);

    /* GET ALGORITHM TABLE ENTRY */
    if ((ae = getalgcode(algorithms, alg, ANY)) == NULL_ALGENT) 
	return(NOTOK);

    /* CHECK THAT KEY LENGTH IS WITHIN POLICY RANGE */
    if (len && (len < ae->minlen || len > ae->maxlen)) 
	return(NOTOK);

    /* GET CALLBACK TABLE ENTRY */
    if ((ce = getccbcode(callbacks, ae->code)) == NULL_CCBENT) 
	return(NOTOK);

    if (ce->gen_Xkey == NULL_FUNC) 
	return(NOTOK);

    /* GENERATE THE KEY */

    if ((r = (*(ce->gen_Xkey))(alg, len, &key1, &key2)) != OK)
	goto cleanup;

    if ((r = encode_key(key1, ekey1)) != OK)
	goto cleanup;

    if (key2 != NULL_KEY && (r = encode_key(key2, ekey2)) != OK)
	goto cleanup;

 cleanup:

    FREE_KEY(key1);
    FREE_KEY(key2);

    return(r);
}
