/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * str2key.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int str2key(aid, cp, ekey)
struct algid *aid;
char *cp;
struct bbuf **ekey;
{
    struct key *key= NULL_KEY;
    struct ccbent *ce = NULL_CCBENT;
    int ret = NOTOK;

    if (aid == NULL_ALGID || cp == NULLCP || ekey == (struct bbuf **)0) 
	return(NOTOK);

    /* GET ALGORITHM TABLE ENTRY */
    if ((ce = getccbcode(callbacks, aid->alg)) == NULL_CCBENT) 
	return(NOTOK);

    if (ce->str2Xkey == NULL_FUNC) 
	return(NOTOK);

    /* CONVERT THE STRING TO A KEY */
    if (alloc_key(&key) != OK 
	|| (key->algid = dup_algid(aid)) == NULL_ALGID
	|| (*(ce->str2Xkey))(cp, &key) != OK) 
        return(NOTOK);

    ret = encode_key(key, ekey);
    FREE_KEY(key);
    return(ret);
}

