/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "key.h"
#include "util.h"

#include "./global.h"
#include "./md2.h"

int cbgen_md2(dummy, cb, md2)
struct key *dummy;		/* ignored */
struct bbuf *(*cb)();		/* cb w/data to be digested */
struct bbuf **md2;		/* message digest to be returned */
{
    MD2_CTX mdContext;
    struct bbuf *buf = NULLBB;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (cb == NULL_INCB || md2 == (struct bbuf **)0) 
	return(NOTOK);

    /* Allocate a bbuf for the digest */

    FREE_BBUF(*md2);
    *md2 = alloc_bbuf();
    (*md2)->data = alloc_uchar(MD2BLKLEN);
    (*md2)->length = MD2BLKLEN;

    /* Compute digest using MD2 routines */

    MD2Init(&mdContext);
    while ((buf = cb()) != NULLBB && buf->length != 0) {
	MD2Update(&mdContext, buf->data, (unsigned int)buf->length);
	FREE_BBUF(buf);
    }
    FREE_BBUF(buf);
    MD2Final((*md2)->data, &mdContext);

    return(OK);
}


