/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "lock.h"
#include "new.h"
#include "util.h"

#define MAXINCLUDES 9

/* Global Variables */

static FILE *index_fp = (FILE *)0,      /* get file pointer */
	    *put_index_fp = (FILE *)0,	/* put file pointer */
            *include_fps [MAXINCLUDES]; /* include fp stack */

static int includes = 0;                /* Current no. of includes */

static char *indexfile = NULLCP,	/* get filename */
	    *p_indexfile = NULLCP,      /* put filename */
            *saved_line = NULLCP;       /* buffered look ahead */


open_include(incline)
char *incline;
{
    int r = NOTOK;
    char *fn, *end;

    if (includes >= MAXINCLUDES || incline == NULLCP || 
	strncasecmp(incline, "$include", 8) != 0)
	goto cleanup;
    for (fn = incline + 8; isspace(*fn); fn++)
	;
    for (end = fn; *end != NULLC && !isspace(*end); end++)
	;
    if (fn == end)
	goto cleanup;
    *end = NULLC;
    if ((include_fps[includes] = fopen(fn, "r")) == (FILE *)0)
	goto cleanup;

    includes++;
    r = OK;
    
 cleanup:
    return r;
}


void close_include()
{
    if (includes > 0) {
	(void) fclose(include_fps[includes-1]);
	include_fps[includes-1] = (FILE *)0;
	includes --;
	FREE(saved_line);
    }
}


set_indexfile(nif)
char *nif;
{
    FREE(indexfile);

    if ((nif == NULLCP) || (*nif == NULLC))
        return NOTOK;
    if (end_indexfile() != OK)
        return NOTOK;

    indexfile = add2cp(NULLCP, nif);
    return OK;
}


rewind_indexfile()
{
    if (index_fp == (FILE *)0) 
        if ((indexfile == NULLCP) 
	    || ((index_fp = fopen(indexfile, "r")) == (FILE *)0))
            return NOTOK;

    while (includes)
	close_include();

    if (fseek(index_fp, 0L, 0) != 0)
        return NOTOK;

    FREE(saved_line);

    return OK;
}


void raw_get_indexfile(user, other)
char ***user, **other;
{
    FILE *fp;
    char *buf = NULLCP;
    char *p = NULLCP, *q = NULLCP, *r = NULLCP;
    char **index_av = NULLVP;

    /* check args */

    if (user == (char ***)0 || other == NULLVP) 
	goto cleanup;

    FREE_AV(*user);
    FREE(*other);

    /* make sure we have a file from which to read */

    if (includes)
	fp = include_fps[includes-1];
    else if (index_fp != (FILE *)0 || rewind_indexfile() == OK)
	fp = index_fp;
    else
	goto cleanup;

    /*  Work with saved line if we have one, otherwise read */

    if (saved_line != NULLCP) {
	buf = saved_line;
	saved_line = NULLCP; 
    } 
    else 
	while ((buf = getline(fp)) == NULLCP) 
	    if (includes){
		close_include();
		if (includes)
		    fp = include_fps[includes-1];
		else 
		    fp = index_fp;
	    }
	    else
		goto cleanup;

    /* Is it a comment, directive, emppty line or orphaned continuation? */

    if (*buf == NULLC || isspace(*buf) || *buf == '#' || *buf == '$') {
	*other = buf;
	buf = NULLCP;
	goto cleanup;
    }

    /* process user record */
	    
    while (1) {
	while (1) {

	    if (buf == NULLCP && (buf = getline(fp)) == NULLCP)
		break;

	    p = buf;

	    if ((q != NULLCP) && (!isspace(*p)))
		break;

	    while (isspace(*p))
		p++;

	    if (*p == NULLC || *buf == '#' || *buf == '$') {
		saved_line = buf;
		buf = NULLCP;
		break;
	    }

	    q = add2cp(q, p);

	    FREE(buf);
	}

	if (q == NULLCP)
	    break;

	if ((p = r = INDEX(q, FS)) == NULLCP)
	    goto cleanup;

	*p-- = NULLC;
	while (isspace(*p))
	    *p-- = NULLC;

	r ++;
	while (isspace(*r))
	    r++;

	index_av = add2av(index_av, add2cp(NULLCP, q));
	index_av = add2av(index_av, add2cp(NULLCP, r));

	FREE(q);

	if (buf == NULLCP)
	    break;
    }

    *user =  index_av;
    index_av = NULLVP;

 cleanup:
    
    FREE(buf);
    FREE(q);
    return;
}


char **get_indexfile()
{
    char **user = NULLVP;
    char *other = NULLCP;

    do {
	FREE(other);
	(void) raw_get_indexfile (&user, &other);
	if (other != NULLCP && *other == '$') {
	    if (strncasecmp (other, "$include", 8) != 0 || 
		open_include (other) != OK)
		goto cleanup;
	}
    } while (other != NULLCP);

 cleanup:

    return user;
}


end_indexfile()
{
    if (index_fp != (FILE *)0) {
        (void) fclose(index_fp);
	index_fp = (FILE *)0;
    }

    while (includes) 
	close_include();

    FREE(saved_line);
	
    return OK;
}


set_put_indexfile(nif)
char *nif;
{
    FREE(p_indexfile);

    if (nif == NULLCP || *nif == NULLC || end_put_indexfile() != OK)
        return NOTOK;

    p_indexfile = add2cp(NULLCP, nif);

    return OK;
}


raw_put_indexfile(s)
char *s;
{
    int r = NOTOK;

    if (put_index_fp == (FILE*)0) {
	if (p_indexfile == NULLCP) 
	    goto cleanup;
	(void) unlink(p_indexfile);
	if (filchk(p_indexfile, 0644, 1) != OK)
	    goto cleanup;
	if ((put_index_fp = lk_fopen(p_indexfile, "w")) == (FILE*)0)
	    goto cleanup;
    }

    if (fputs(s, put_index_fp) == EOF)
	goto cleanup;
    if (putc('\n', put_index_fp) != '\n')
	goto cleanup;
    r = OK;

 cleanup:

    return r;
}


put_indexfile(it)
char **it;
{
    char *fstr = NULLCP, **fav = NULLVP, **av = NULLVP;
    int r = NOTOK;

    if (it == NULLVP) 
	goto cleanup;

    while ((*it != NULLCP) && (*(it+1) != NULLCP)) {
	fstr = add2cp(fstr, *it++);
	fstr = add2cp(fstr, FS_STRING);
	fstr = add2cp(fstr, *it++);
	if ((av = fold(fstr, 72, " ")) == NULLVP)
	    goto cleanup;
	FREE(fstr);
	for (fav = av; *fav != NULLCP; fav++) 
	    if (raw_put_indexfile (*fav) == NOTOK)
		goto cleanup;
	FREE_AV(av);
    }

    r = OK;

 cleanup:

    return r;
}


end_put_indexfile()
{
    if (put_index_fp != (FILE*)0)
        (void) lk_fclose(put_index_fp);
    put_index_fp = (FILE*)0;

    return OK;
}


int update_indexfile(remove, add)
char **remove, **add;
{
    char *putname = NULLCP, *oldput = NULLCP;
    FILE *oldputfp = (FILE *)0;
    char **rpkey = NULLVP, **apkey = NULLVP;
    char **user = NULLVP;
    char *other = NULLCP;
    char *incline = NULLCP;
    int r = NOTOK, replaced = 0, wasblank = 1;
    
    if (remove == NULLVP && add == NULLVP)
	return OK;

    if (remove != NULLVP)
	rpkey = tag_user(remove, "public-key");

    if (add != NULLVP)
	apkey = tag_user(add, "public-key");

    /* save the state of the old put file */

    oldput = p_indexfile;
    p_indexfile = NULLCP;

    oldputfp = put_index_fp;
    put_index_fp = (FILE *)0;

    /* setup a new put file for us to use */

    putname = add2cp(NULLCP, indexfile);
    putname = add2cp(putname, ".XXXXXX");
    (void) mktemp(putname);
    if (set_put_indexfile(putname) != OK) 
	goto cleanup;

    /* reset current get file and start updating */

    (void) rewind_indexfile();

    do {
	FREE_AV(user);
	FREE(other);
	raw_get_indexfile(&user, &other);

	/*  Output include line we've been holding */

	if (!includes && incline != NULLCP) {
            if (raw_put_indexfile(incline) != OK)
                goto cleanup;
	    wasblank = 0;
            FREE(incline);
        }

	if (user != NULLVP) {
	    
	    /* We check the current record with add first and if it matches
	     * we replace it with the add record.  If we do the replacement
	     * we do not need to check the remove record, since the
	     * replacement is effectively a removal of the old.
	     *
	     * We need to remember if we have done the replacement so we can
	     * append the add record if it does not already appear.
	     */

	    if (apkey != NULLVP && !replaced && 
		tagval_user(user, "public-key", *(apkey+1)) != NULLVP) {
		if (includes && !wasblank && raw_put_indexfile("") != OK)
                    goto cleanup;
		if (put_indexfile(add) != OK)
		    goto cleanup;
		if (includes && raw_put_indexfile("") != OK)
		    goto cleanup;
		replaced++;
		wasblank = 0;
	    }
	    else if (!includes && (rpkey == NULLVP ||
		tagval_user(user, "public-key", *(rpkey+1)) == NULLVP))
		if (!includes) {
		    if (put_indexfile(user) != OK)
			goto cleanup;
		    wasblank = 0;
		}
	}
	else if (other != NULLCP) {

	    if (strncasecmp(other, "$include", 8) != 0) {
		if (!includes) {
		    if (raw_put_indexfile(other) != OK)
			goto cleanup;
		    wasblank = *other == NULLC || isspace(*other);
		}
	    }
	    else {
		if (!includes) 
		    incline = add2cp(NULLCP, other);
		if (open_include (other) != OK)
		    goto cleanup;
	    }
	}

	if (includes && (replaced || apkey == NULLVP))
	    while (includes)
		close_include();

    } while (user != NULLVP || other != NULLCP);

    /* add the new record if it was not a replacement */
    
    if (add != NULLVP && !replaced) {
	if (!wasblank && raw_put_indexfile("") != OK)
	    goto cleanup;
	if (put_indexfile(add) != OK)
	    goto cleanup;
    }
    
    (void) end_indexfile();
    (void) end_put_indexfile();
    if (rename(putname, indexfile))
	goto cleanup;

    r = OK;

 cleanup:

    /* reset old put file */

    (void) end_put_indexfile();

    p_indexfile = oldput;
    put_index_fp = oldputfp;

    if (putname != NULLCP) {
	(void) unlink(putname);
	FREE(putname);
    }

    FREE_AV(user);

    return r;
}
