/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"
#include "x500.h"

/* Extract the tag and ASN.1 encoded data */

unsigned char asn_extract(bbuf, sub_bbuf, pos)
struct bbuf *bbuf, 
	    **sub_bbuf;
int 	    *pos;
{
    unsigned char tag, ret = PARSE_ERROR;
    int llen, slen;

    if (bbuf == NULLBB) 
        return(ret);

    if (sub_bbuf == (struct bbuf **)0) 
        goto cleanup;

    FREE_BBUFS(*sub_bbuf);

    if (pos == (int *)0) 
	return(ret);

    if (bbuf->length < *pos+2) 
        goto cleanup;

    tag = bbuf->data[*pos];
    /* Grab the subelement */
    *sub_bbuf = alloc_bbuf();

    slen = (*sub_bbuf)->length;
    if (decode_len(&(bbuf->data[++*pos]), bbuf->length-1, 
		   &slen, &llen) != OK) 
        goto cleanup;

    (*sub_bbuf)->length = (short)slen;
    *pos += llen;
    
    if ((*sub_bbuf)->length > bbuf->length-(sizeof(tag)+llen)) 
        goto cleanup;

    if ((*sub_bbuf)->length
	&& ((*sub_bbuf)->data = alloc_uchar((*sub_bbuf)->length)) == NULLUCP) 
        goto cleanup;

    BCOPY(&(bbuf->data[*pos]), (*sub_bbuf)->data, (*sub_bbuf)->length); 
    *pos += (*sub_bbuf)->length;
    ret = tag;

 cleanup:

    if (ret == PARSE_ERROR)
	FREE_BBUF(*sub_bbuf);

    return(ret);
}
