/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "msg.h"
#include "new.h"
#include "userlist.h"
#include "util.h"

moss_decrypt(msg, opts, iocbs)
struct msg *msg;
long opts;
struct cbstruct *iocbs;
{
    struct bbuf *key = NULLBB;
    struct bbuf *mykey = NULLBB;
    struct bbuf *keydata = NULLBB;
    struct bbuf *privkey = NULLBB;
    struct user_list *rulptr = NULLUL, *oulptr = NULLUL;
    char **me = NULLVP;
    char **tagptr = NULLVP;
    struct algent *ae = NULL_ALGENT;
    struct algid *key_aid = NULL_ALGID;
    char **av = NULLVP;
    char *cp = NULLCP;
    char *pu = NULLCP;
    int status = NOTOK;
    int foundme = 0;

    if (msg == NULL_MSG || msg -> origusers == NULLUL || iocbs == NULL_IOCBS
	|| iocbs -> in_data == NULL_INCB || iocbs -> out_data == NULL_OUTCB) 
	goto cleanup;

    /* check recipient list for me */

    for (rulptr = msg->recipusers, key = msg->recipkey; 
	 rulptr != NULLUL && key != NULLBB; 
	 rulptr = rulptr->next, key = key->next) {

	for (oulptr = msg->origusers; oulptr != NULLUL;
	     oulptr = oulptr->next) {
	    foundme = 1;
	    for (tagptr = rulptr->user; tagptr != NULLVP
		 && *tagptr != NULLCP; tagptr += 2)
		if (!tagval_user(oulptr->user, *tagptr, *(tagptr+1))) {
		    foundme = 0;
		    break;
		}
	    if (foundme) {
		me = oulptr->user;
		mykey = key;
		break;
	    }
	}

	if (foundme) {
	    if (!((opts & DECRYPT_SHOWRECIPS) 
		  && iocbs->out_hdrs != NULL_OUTCB))
		break;
	}
	else if (opts & DECRYPT_SHOWRECIPS) {
	    cp = add2cp(NULLCP, "Message also encrypted for ");
	    pu = pretty_user(rulptr->user);
            cp = add2cp(cp, pu);
            cp = add2cp(cp, ".\n");
            (void) cp2cb(iocbs->out_hdrs, cp);
            FREE(pu);
            FREE(cp);
	}
    }

    if (me == NULLVP) {
	(void) cp2cb(iocbs -> out_errs, "\nMessage not encrypted for you.\n");
	goto cleanup;
    }
    else {
	cp = add2cp(NULLCP, "Message encrypted for you as ");
	pu = pretty_user(me);
	cp = add2cp(cp, pu);
	cp = add2cp(cp, ".\n");
	(void) cp2cb(iocbs->out_hdrs, cp);
	FREE(pu);
	FREE(cp);
    }

    /* get the private key */

    if (moss_getkey(me, &privkey, iocbs) != OK)
	goto cleanup;

    if (set_key(privkey) != OK) {
	cp2cb(iocbs->out_errs, "Unable to use private key.\n");
	goto cleanup;
    }
 
    /* decrypt message DEK */

    if (decipher(mykey, &keydata)) {
	(void) cp2cb(iocbs -> out_errs, "Unable to decrypt DEK.\n");
	goto cleanup;
    }
    
    /* construct DEK from data and params */

    key = alloc_bbuf();
    key_aid = alloc_algid();

    if ((ae = getalghdrstr(algorithms, msg -> dekalg, DEK)) == NULL_ALGENT) {
	cp = add2cp(NULLCP, msg -> dekalg);
	cp = add2cp(cp, " is an unknown DEK algorithm/mode header string.\n");
	(void) cp2cb(iocbs -> out_errs, cp);
	FREE(cp);
	goto cleanup;
    }
    key_aid -> alg = ae -> code;
    if (algid_key(&key, &key_aid, WRITE) != OK
	|| str2dekparms((char *)(msg -> dekinfo -> data), &key) != OK
	|| bbuf2dekdata(keydata, &key) != OK) {
	(void) cp2cb(iocbs -> out_errs, "Unable to construct DEK.\n");
	goto cleanup;
    }

    if ((opts & DECRYPT_SHOWKEY) && iocbs -> out_hdrs != NULL_OUTCB) {
	av = add2av(NULLVP, add2cp(NULLCP, "Decrypted DEK:"));
	(void) disp_key(key, &av);
	av = add2av(av, add2cp(NULLCP, " "));
	(void) av2cb(iocbs -> out_hdrs, av);
	FREE_AV(av);
    }	

    /* decipher data */

    if (set_key(key) != OK) {
	(void) cp2cb(iocbs -> out_errs, "Unable to use key to decipher.\n");
	goto cleanup;
    }

    if (cbdecipher(iocbs -> in_data, iocbs -> out_data) != OK) {
	(void) cp2cb(iocbs -> out_errs, "Unable to decipher data.\n");
	goto cleanup;
    }
	
    status = OK;

 cleanup:

    FREE_ALGID(key_aid);
    FREE_AV(av);

    FREE_BBUF(key);
    FREE_BBUF(keydata);
    FREE_BBUF(privkey);

    return(status);
}
